/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.xmlconversionservice;

import csbase.exception.BugException;
import csbase.exception.ServiceFailureException;
import csbase.logic.Utilities;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.XMLConversionServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.xmlconversionservice.ServiceUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Calendar;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.xml.conversion.XMLConverter;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;

public class XMLConversionService
extends Service
implements XMLConversionServiceInterface {
    public XMLConversionService() throws ServerException {
        super("XMLConversionService");
        ClientRemoteLocator.xmlConversionService = this;
    }

    @Override
    public void initService() throws ServerException {
    }

    @Override
    public void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLConverter.XMLConversionStatus convertXMLToFile(Object projectId, String[] clientPath, boolean validate, String dtdPrefix, Class<? extends XMLConverter> clazz) throws RemoteException {
        block9: {
            block8: {
                projectService = ProjectService.getInstance();
                status = null;
                xmlData = null;
                outputStream = null;
                try {
                    converter = this.createConverter(dtdPrefix, clazz);
                    xmlData = this.readXMLAsString(projectId, clientPath);
                    this.preConvert(projectId, clientPath, dtdPrefix, xmlData);
                    status = converter.convert(xmlData, validate).getConversionStatus();
                    if (status == XMLConverter.XMLConversionStatus.NOT_NEEDED) {
                        this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                        var11_14 = status;
                        this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                        if (outputStream == null) break block8;
                    }
                    ** GOTO lbl-1000
                }
                catch (IOException e) {
                    try {
                        throw new ServiceFailureException(this.getString("XMLConversionService.error.io"), (Throwable)e);
                        catch (Exception e) {
                            throw new ServiceFailureException(e.toString(), (Throwable)e);
                        }
                    }
                    catch (Throwable var12_15) {
                        this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                        if (outputStream != null) {
                            FileUtils.close(outputStream);
                        }
                        throw var12_15;
                    }
                }
                FileUtils.close((Closeable)outputStream);
            }
            return var11_14;
lbl-1000:
            // 1 sources

            {
                outputStream = projectService.getOutputStream(projectId, clientPath);
                converter.saveTo(outputStream);
                this.postConvert(projectId, clientPath, dtdPrefix, outputStream, xmlData, status);
                if (outputStream == null) break block9;
            }
            FileUtils.close((Closeable)outputStream);
        }
        date = Calendar.getInstance().getTimeInMillis();
        text = MessageFormat.format(this.getString("XMLConversionService.success.msg"), new Object[]{Utilities.getFormattedDate((long)date), Service.getUser().getId()});
        projectService.appendFileDescription(projectId, clientPath, text);
        return status;
    }

    private <T extends XMLConverter> T createConverter(String dtdPrefix, Class<T> clazz) throws Exception {
        XMLConverter converter = null;
        try {
            Constructor<T> constructor = clazz.getConstructor(String.class);
            converter = (XMLConverter)constructor.newInstance(dtdPrefix);
        }
        catch (NoSuchMethodException e) {
            String text = MessageFormat.format(this.getString("XMLConversionService.error.impl.no_constructor_found"), clazz.getName());
            throw new BugException(text, (Throwable)e);
        }
        return (T)converter;
    }

    protected void postConvert(Object projectId, String[] clientPath, String dtdPrefix, OutputStream outputStream, String xmlData, XMLConverter.XMLConversionStatus status) {
    }

    protected void preConvert(Object projectId, String[] clientPath, String dtdPrefix, String xmlData) {
    }

    private String readXMLAsString(Object projectId, String[] clientPath) throws IOException {
        InputStream inputStream = ProjectService.getInstance().getInputStream(projectId, clientPath);
        String xmlData = ServiceUtils.readXMLAsString(inputStream, this.getXMLEndMarker());
        return xmlData;
    }

    protected String getXMLEndMarker() {
        return null;
    }

    public String convertXMLToString(Object projectId, String[] clientPath, boolean validate, String dtdPrefix, Class<? extends XMLConverter> clazz) throws RemoteException {
        try {
            XMLConverter converter = this.createConverter(dtdPrefix, clazz);
            String xmlData = this.readXMLAsString(projectId, clientPath);
            converter.convert(xmlData, validate);
            return converter.saveToString();
        }
        catch (IOException e) {
            throw new ServiceFailureException(this.getString("XMLConversionService.error.io"), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceFailureException(e.toString(), (Throwable)e);
        }
    }

    protected void append(File src, OutputStream outputStream) throws XMLConversionException {
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            reader = new BufferedReader(new FileReader(src));
            String line = reader.readLine();
            while (line != null) {
                writer.write(line);
                writer.write(10);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                String msg = "Erro: src: " + src.getAbsolutePath() + " - outputStream: " + outputStream.toString();
                Server.logSevereMessage(msg, e);
                throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.WRITE);
            }
            catch (Throwable throwable) {
                FileUtils.close(reader);
                FileUtils.close(writer);
                throw throwable;
            }
        }
        FileUtils.close((Closeable)reader);
        FileUtils.close((Closeable)writer);
    }

    public static XMLConversionService getInstance() {
        return (XMLConversionService)XMLConversionService.getInstance("XMLConversionService");
    }

    public static void createService() throws ServerException {
        new XMLConversionService();
    }
}

