/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.repositoryservice;

import csbase.server.services.repositoryservice.IRepositoryFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import tecgraf.javautils.core.io.FileUtils;

class LocalTempFile
implements IRepositoryFile {
    private File file;
    private RandomAccessFile raf;

    LocalTempFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file n\u00e3o pode ser nulo.");
        }
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public List<IRepositoryFile> getChildren() {
        if (this.isRegularFile()) {
            return null;
        }
        LinkedList<IRepositoryFile> result = new LinkedList<IRepositoryFile>();
        for (File child : this.file.listFiles()) {
            result.add(new LocalTempFile(child));
        }
        return result;
    }

    @Override
    public IRepositoryFile getChild(String ... path) {
        String filePath = FileUtils.joinPath((char)File.separatorChar, (String[])path);
        filePath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.getPath(), filePath});
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        return new LocalTempFile(file);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long getModificationDate() {
        return this.file.lastModified();
    }

    @Override
    public IRepositoryFile getParent() {
        File parentFile = this.file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        return new LocalTempFile(parentFile);
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isRegularFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite();
    }

    @Override
    public boolean isExecutable() {
        return this.file.canExecute();
    }

    @Override
    public boolean lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean release() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isLocked()) {
            throw new IOException(String.format("Arquivo bloqueado: %s", this));
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public FileChannel getFileChannel(String mode) throws IOException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, mode);
        }
        return this.raf.getChannel();
    }

    @Override
    public void close() throws WebServiceException {
        FileUtils.close((Closeable)this.raf);
        this.raf = null;
    }

    @Override
    public String getFullPath() {
        return this.file.getAbsolutePath();
    }
}

