/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.wioservice;

import csbase.logic.User;
import csbase.logic.UserProjectInfo;
import csbase.server.Server;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.wioservice.WIOServerProject;
import csbase.server.services.wioservice.WIOService;
import csbase.server.services.wioservice.idl.AlgorithmInfo;
import csbase.server.services.wioservice.idl.UserProject;
import csbase.server.services.wioservice.idl.WIOFileSystemPOA;
import csbase.server.services.wioservice.idl.WIOProject;
import csbase.server.services.wioservice.idl.WIOProjectHelper;
import csbase.server.services.wioservice.idl.WIOServiceException;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class WIOServerFileSystem
extends WIOFileSystemPOA {
    protected static String FILE_SEPARATOR = "|";
    private WIOService service = null;
    private int numProjects = 0;
    private int numTotalFiles = 0;
    private static Comparator<UserProject> COMPARATOR = new Comparator<UserProject>(){

        @Override
        public int compare(UserProject o1, UserProject o2) {
            String n1 = o1.projectId;
            String n2 = o2.projectId;
            return n1.compareToIgnoreCase(n2);
        }
    };

    public boolean checkPassword(String userId, String passwd) {
        return this.isCorrectPassword(userId, passwd);
    }

    private void checkService() throws Exception {
        if (this.service == null) {
            String err = "Servico de WIO com referencia nula!";
            throw new Exception("Servico de WIO com referencia nula!");
        }
    }

    protected void decNumFiles() throws Exception {
        this.checkService();
        --this.numTotalFiles;
    }

    protected void decNumProjects() throws Exception {
        this.checkService();
        int MAX_NUM_PROJS = this.service.getMaxOpenedProjects();
        if (this.numProjects <= 0) {
            String err = "Underflow em numero de projetos.";
            throw new Exception("Underflow em numero de projetos.");
        }
        --this.numProjects;
        Server.logInfoMessage("Decremento do numero de projetos abertos: " + this.numProjects + "/" + MAX_NUM_PROJS);
    }

    public int getMaxOpenedProjects() throws WIOServiceException {
        try {
            this.checkService();
            return this.service.getMaxOpenedProjects();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na consulta de max-opened", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public int getMaxReadKb() throws WIOServiceException {
        try {
            this.checkService();
            return this.service.getMaxReadKb();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na consulta de max-read", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public int getMaxWriteKb() throws WIOServiceException {
        try {
            this.checkService();
            return this.service.getMaxWriteKb();
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na consulta de max-write", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    int getNumOpenedFiles() {
        return this.numTotalFiles;
    }

    public int getNumOpenedProjects() {
        return this.numProjects;
    }

    public String[] getProjects(String userLogin, String password) throws WIOServiceException {
        String[] names;
        if (!this.isCorrectPassword(userLogin, password)) {
            String msg = "Falha de autenticacao na busca por projetos. ";
            msg = msg + "Usuario: " + userLogin;
            Server.logSevereMessage(msg);
            throw new WIOServiceException(msg);
        }
        try {
            ProjectService prjService = ProjectService.getInstance();
            ProjectService.setUserId(User.getAdminId());
            List<UserProjectInfo> projects = prjService.getProjectsFromUser(userLogin);
            int prjsSize = projects.size();
            names = new String[prjsSize];
            for (int i = 0; i < prjsSize; ++i) {
                names[i] = projects.get(i).getProjectName();
            }
        }
        catch (Exception e) {
            String err = "Falha na busca de projetos proprios";
            Server.logSevereMessage("Falha na busca de projetos proprios", e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        finally {
            ProjectService.setUserId(null);
        }
        Arrays.sort(names, new Comparator<String>(){

            @Override
            public int compare(String n1, String n2) {
                return n1.compareToIgnoreCase(n2);
            }
        });
        return names;
    }

    public UserProject[] getProjectsFromOthers(String userLogin, String password) throws WIOServiceException {
        if (!this.isCorrectPassword(userLogin, password)) {
            String err = "Falha de autenticacao na busca por projetos compartilhados";
            err = err + "\nUsuario: " + userLogin;
            Server.logSevereMessage(err);
            throw new WIOServiceException(err);
        }
        try {
            ProjectService prjService = ProjectService.getInstance();
            ProjectService.setUserId(User.getAdminId());
            List<UserProjectInfo> userProjects = prjService.getProjectsSharedWithUser(userLogin);
            int np = userProjects.size();
            UserProject[] ups = new UserProject[np];
            for (int i = 0; i < np; ++i) {
                UserProjectInfo uInfo = userProjects.get(i);
                ups[i] = new UserProject();
                ups[i].ownerId = (String)uInfo.getOwnerId();
                ups[i].ownerName = User.getName((java.lang.Object)uInfo.getOwnerId());
                ups[i].projectId = uInfo.getProjectName();
            }
            Arrays.sort(ups, COMPARATOR);
            UserProject[] userProjectArray = ups;
            return userProjectArray;
        }
        catch (Exception e) {
            String err = "Falha na busca de projetos compartilhados";
            Server.logSevereMessage("Falha na busca de projetos compartilhados");
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
        finally {
            ProjectService.setUserId(null);
        }
    }

    public String getSeparatorChar() {
        return FILE_SEPARATOR;
    }

    public String getServerVersion() {
        return "6.0";
    }

    protected void incNumFiles() throws Exception {
        this.checkService();
        ++this.numTotalFiles;
    }

    protected void incNumProjects() throws Exception {
        this.checkService();
        int MAX_NUM_PROJS = this.service.getMaxOpenedProjects();
        if (this.numProjects >= MAX_NUM_PROJS) {
            String err = "Overflow em numero de projetos.";
            throw new Exception("Overflow em numero de projetos.");
        }
        ++this.numProjects;
        Server.logInfoMessage("Incremento do numero de projetos abertos: " + this.numProjects + "/" + MAX_NUM_PROJS);
    }

    private boolean isCorrectPassword(String userLogin, String password) {
        try {
            LoginService loginService = LoginService.getInstance();
            User user = loginService.checkLogin(userLogin, password);
            return user != null;
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na autentica\u00e7\u00e3o do WIOService!", e);
            return false;
        }
    }

    private WIOProject internalOpen(String userLogin, String ownerLogin, String projectName) throws Exception {
        WIOServerProject prj;
        try {
            prj = new WIOServerProject(this, userLogin, ownerLogin, projectName);
        }
        catch (Exception e) {
            String err = "Excecao detectada na abertura de projeto";
            Server.logSevereMessage("Excecao detectada na abertura de projeto", e);
            throw new Exception("Excecao detectada na abertura de projeto", e);
        }
        Server.logInfoMessage("Instanciado projeto [" + projectName + "]...");
        POA poa = prj.activateCorbaProject();
        if (poa == null) {
            String err = "Falha detectada na ativ. de projeto";
            throw new Exception("Falha detectada na ativ. de projeto");
        }
        WIOProject cprj = WIOProjectHelper.narrow((Object)poa.servant_to_reference((Servant)prj));
        if (cprj == null) {
            String err = "Falha de narrow ao criar CORBA do projeto";
            Server.logSevereMessage("Falha de narrow ao criar CORBA do projeto:" + projectName);
            throw new Exception("Falha de narrow ao criar CORBA do projeto");
        }
        if (cprj._non_existent()) {
            String err = "Falha de non-existent CORBA em projeto";
            Server.logSevereMessage("Falha de non-existent CORBA em projeto:" + projectName);
            throw new Exception("Falha de non-existent CORBA em projeto");
        }
        return cprj;
    }

    public WIOProject openProject(String userLogin, String password, String projectName) throws WIOServiceException {
        Server.logInfoMessage("Pedido de abertura de [" + projectName + "].");
        if (!this.isCorrectPassword(userLogin, password)) {
            String msg = "Falha de autenticacao na abertura do projeto ";
            msg = msg + "\nProjeto: " + userLogin;
            msg = msg + "\nUsuario: " + userLogin;
            Server.logSevereMessage(msg);
            throw new WIOServiceException(msg);
        }
        try {
            WIOProject prj = this.internalOpen(userLogin, userLogin, projectName);
            String msg = "Sucesso na abertura de [" + projectName + "]";
            Server.logInfoMessage(msg);
            return prj;
        }
        catch (Exception e) {
            String err = "Falha na abertura de [" + projectName + "]";
            Server.logSevereMessage(err, e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public WIOProject openProjectFromOthers(String userLogin, String password, String ownerLogin, String projectName) throws WIOServiceException {
        Server.logInfoMessage("Pedido de abertura do projeto compartilhado [" + projectName + "]...");
        if (!this.isCorrectPassword(userLogin, password)) {
            String msg = "Falha de autenticacao na abertura do projeto ";
            msg = msg + "\nProjeto: " + userLogin;
            msg = msg + "\nUsu\u00e1rio: " + userLogin;
            msg = msg + "\nDono: " + ownerLogin;
            Server.logSevereMessage(msg);
            throw new WIOServiceException(msg);
        }
        try {
            WIOProject prj = this.internalOpen(userLogin, ownerLogin, projectName);
            String fmt = "Sucesso na abertura de [%s] (shared)";
            String msg = String.format("Sucesso na abertura de [%s] (shared)", projectName);
            Server.logInfoMessage(msg);
            return prj;
        }
        catch (Exception e) {
            String fmt = "Falha na abertura de [%s] (shared)";
            String err = String.format("Falha na abertura de [%s] (shared)", projectName);
            Server.logSevereMessage(err, e);
            throw new WIOServiceException(WIOService.getExceptionString(e));
        }
    }

    public String preLogin2Web(String login, String password, String projectName, AlgorithmInfo algorithmInfo) {
        return this.service.preLogin2Web(login, password, projectName, algorithmInfo);
    }

    protected WIOServerFileSystem(WIOService srv) {
        FILE_SEPARATOR = File.separator;
        if (FILE_SEPARATOR.equals("\\")) {
            FILE_SEPARATOR = "\\\\";
        }
        this.service = srv;
    }
}

