/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import csbase.server.services.restservice.websocket.WebSocketUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class CSBaseWebSocket
extends DefaultWebSocket {
    private static final Logger logger = Grizzly.logger(CSBaseWebSocket.class);
    private volatile String id = UUID.randomUUID().toString();
    private volatile User user;
    private volatile Project project;
    private volatile long timestamp = System.currentTimeMillis();

    public CSBaseWebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) throws UnsupportedEncodingException {
        super(protocolHandler, request, listeners);
        this.user = this.authenticate(request);
    }

    private User authenticate(HttpRequestPacket request) throws UnsupportedEncodingException, IllegalArgumentException {
        String[] cookies = URLDecoder.decode(request.getHeader("cookie"), "UTF-8").split(";");
        User user = null;
        for (String cookie : cookies) {
            if (!WebSocketUtils.isJSONValid(cookie)) continue;
            user = new User(cookie);
        }
        if (user == null || !user.has("login")) {
            throw new IllegalArgumentException("User login is required for websocket authentication");
        }
        return user;
    }

    public String getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

