/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.server.services.restservice.websocket.User;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Project
extends JSONObject {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String OWNER = "owner";
    public static final String EDITABLE = "editable";
    public static final String MODIFIED = "modified";
    public static final String CREATED = "created";
    public static final String TYPE = "type";
    public static final String VISIBILITY = "visibility";
    public static final String VISIBILITY_PRIVATE = "private";
    public static final String VISIBILITY_PUBLIC_RO = "public_ro";
    public static final String VISIBILITY_PUBLIC_RW = "public_rw";
    public static final String VISIBILITY_SELECTIVE = "selective";
    public static final String MEMBERS = "members";

    public Project(String source) throws JSONException {
        super(source);
    }

    public Project(JSONObject json) {
        super(json.toString());
    }

    public Boolean isVisible(User user) {
        if (user.isAdmin().booleanValue()) {
            return true;
        }
        if (this.getVisibility().equals(VISIBILITY_PRIVATE)) {
            return this.isOwner(user);
        }
        if (this.getVisibility().equals(VISIBILITY_SELECTIVE)) {
            return this.isOwner(user) != false || this.isMember(user) != false;
        }
        return this.getVisibility().equals(VISIBILITY_PUBLIC_RW) || this.getVisibility().equals(VISIBILITY_PUBLIC_RO);
    }

    public Boolean isOwner(User user) {
        return user.getLogin().equals(this.getOwner().getLogin());
    }

    public Boolean isMember(User user) {
        String login = user.getLogin();
        for (int i = 0; i < this.getMembers().length(); ++i) {
            if (!login.equals(this.getMembers().getJSONObject(i).get("login"))) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.getString(ID);
    }

    public void setId(String id) {
        this.put(ID, id);
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.put(NAME, name);
    }

    public User getOwner() {
        return new User(this.getJSONObject(OWNER));
    }

    public void setOwner(User owner) {
        this.put(OWNER, (Object)owner);
    }

    public String getVisibility() {
        return this.getString(VISIBILITY);
    }

    public void setVisibility(String visibility) {
        this.put(VISIBILITY, visibility);
    }

    public JSONArray getMembers() {
        return this.getJSONArray(MEMBERS);
    }

    public void setMembers(JSONArray members) {
        this.put(MEMBERS, members);
    }
}

