/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket.notificationcenter;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.EvictingQueue;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.Message;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.OptimizedBroadcaster;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class CSBaseNotificationCenter
extends WebSocketApplication {
    private static final Logger logger = Grizzly.logger(CSBaseNotificationCenter.class);
    private static final int NOTIFICATION_HISTORY_MAX_SIZE = 20;
    private static ConcurrentHashMap<String, CSBaseWebSocket> connections = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, EvictingQueue<JSONObject>> notifications = new ConcurrentHashMap();
    private final Broadcaster broadcaster = new OptimizedBroadcaster();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ObjectMapper mapper = new ObjectMapper();

    public CSBaseNotificationCenter() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.scheduler.scheduleAtFixedRate(() -> connections.values().forEach(ws -> ws.sendPing(new byte[0])), 0L, 60L, TimeUnit.SECONDS);
        this.setOnJobTerminateListener();
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket request, WebSocketListener ... listeners) {
        System.out.println("CSBaseNotificationCenter: Creating socket");
        try {
            CSBaseWebSocket ws = new CSBaseWebSocket(handler, request, listeners);
            if (connections.containsKey(ws.getUser().getLogin())) {
                return null;
            }
            connections.put(ws.getUser().getLogin(), ws);
            if (!notifications.containsKey(ws.getUser().getLogin())) {
                notifications.put(ws.getUser().getLogin(), (EvictingQueue<JSONObject>)EvictingQueue.create((int)20));
            }
            return ws;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onConnect(WebSocket ws) {
        System.out.println("onConnect");
        String user = ((CSBaseWebSocket)ws).getUser().getLogin();
        if (notifications.containsKey(user) && notifications.get(user).size() > 0) {
            ws.send(this.createNotificationHistoryMessage(user).toString());
        }
    }

    public void onMessage(WebSocket ws, String json) {
        System.out.println("onMessage: " + json);
    }

    public void onClose(WebSocket ws, DataFrame frame) {
        System.out.println("onClose " + frame.toString());
        connections.remove(((CSBaseWebSocket)ws).getUser().getLogin());
    }

    public void onPing(WebSocket ws, byte[] bytes) {
        super.onPing(ws, bytes);
        System.out.println("onPing");
    }

    public void onPong(WebSocket ws, byte[] bytes) {
        super.onPong(ws, bytes);
        System.out.println("CSBaseNotificationCenter: onPong");
    }

    protected boolean onError(WebSocket ws, Throwable t) {
        System.out.println("onError " + t.getLocalizedMessage());
        t.printStackTrace();
        return super.onError(ws, t);
    }

    private void setOnJobTerminateListener() {
        System.out.println("setOnJobTerminateListener");
        MessageService.getInstance().setServerMessageListener((IMessageListener & Serializable)messages -> {
            for (csbase.util.messages.Message message : messages) {
                try {
                    System.out.println(message.getBody().getClass().getSimpleName() + ": " + message.getBody());
                    if (!(message.getBody() instanceof CommandNotification)) continue;
                    CommandNotification commandNotification = (CommandNotification)message.getBody();
                    JSONObject content = new JSONObject(this.mapper.writeValueAsString((Object)commandNotification));
                    String project = content.getString("projectId").split("/")[1];
                    content.put("project", (Object)project);
                    CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(commandNotification.getProjectId(), commandNotification.getCommandId().toString());
                    String user = commandInfo.getUserId().toString();
                    content.put("user", (Object)user);
                    Message commandTerminate = this.createCommandTerminateMessage(content);
                    connections.values().forEach(ws -> {
                        if (ws.getUser().getLogin().equals(user)) {
                            notifications.get(ws.getUser().getLogin()).add((Object)content);
                            ws.send(commandTerminate.toString());
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new BodyTypeFilter(CommandNotification.class));
    }

    private Message createCommandTerminateMessage(JSONObject content) throws JsonProcessingException {
        Message commandTerminate = new Message();
        commandTerminate.setType("cmdtmt");
        commandTerminate.setContent(content);
        return commandTerminate;
    }

    private Message createNotificationHistoryMessage(String user) {
        JSONArray jsonArray = new JSONArray();
        notifications.get(user).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        Message history = new Message();
        history.setType("nhist");
        history.setContent(jsonArray.toString());
        return history;
    }
}

