/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.exception.ParseException;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.restservice.RestService;
import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import ibase.authentication.UnauthorizedException;
import java.util.Hashtable;
import java.util.UUID;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class CSBaseWebSocket
extends DefaultWebSocket {
    private static final Logger logger = Grizzly.logger(CSBaseWebSocket.class);
    private volatile String id = UUID.randomUUID().toString();
    private volatile User user;
    private volatile Project project;
    private volatile long timestamp = System.currentTimeMillis();

    public CSBaseWebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) throws UnauthorizedException {
        super(protocolHandler, request, listeners);
        this.authenticate(request);
    }

    private void authenticate(HttpRequestPacket request) throws UnauthorizedException {
        AdministrationService adminService = AdministrationService.getInstance();
        Hashtable<String, Object> attributes = new Hashtable<String, Object>();
        try {
            String userId = RestService.getInstance().parserToken(request.getQueryString(), attributes);
            if (userId == null) {
                throw new UnauthorizedException("Token inv\u00e1lido");
            }
            csbase.logic.User user = adminService.getUser(userId);
            if (user == null) {
                throw new UnauthorizedException("Usu\u00e1rio " + userId + " n\u00e3o existe");
            }
            this.user = new User();
            this.user.setId(userId);
            this.user.setLogin(user.getLogin());
            this.user.setName(user.getName());
        }
        catch (ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public String getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

