/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket.messenger;

import com.google.common.collect.EvictingQueue;
import csbase.logic.UserNotification;
import csbase.logic.UserOutline;
import csbase.server.Server;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.Message;
import csbase.server.services.restservice.websocket.PersistentObject;
import csbase.server.services.restservice.websocket.Project;
import csbase.server.services.restservice.websocket.User;
import csbase.server.services.restservice.websocket.WebSocketUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.OptimizedBroadcaster;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class CSBaseMessenger
extends WebSocketApplication {
    private static final int MESSENGER_HISTORY_MAX_SIZE = 100;
    private static final String MESSENGER_FILE = "wsmessenger.dat";
    private static PersistentObject<EvictingQueue<String>> messages = new PersistentObject<EvictingQueue>(WebSocketUtils.generatePath("wsmessenger.dat"), EvictingQueue.create((int)100));
    private static ConcurrentHashMap<String, CSBaseWebSocket> connections = new ConcurrentHashMap();
    private final Broadcaster broadcaster = new OptimizedBroadcaster();

    public CSBaseMessenger() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> connections.values().forEach(ws -> ws.sendPing(new byte[0])), 0L, 60L, TimeUnit.SECONDS);
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket request, WebSocketListener ... listeners) {
        System.out.println("CSBaseMessenger: Creating socket");
        try {
            CSBaseWebSocket ws = new CSBaseWebSocket(handler, request, listeners);
            if (connections.containsKey(ws.getUser().getLogin())) {
                return null;
            }
            connections.put(ws.getUser().getLogin(), ws);
            return ws;
        }
        catch (Exception e) {
            e.printStackTrace();
            Server.logSevereMessage("Erro ao criar messenger websocket", e);
            return null;
        }
    }

    public void onConnect(WebSocket ws) {
        System.out.println("onConnect");
        this.broadcast(this.createUserListUpdateMessage(connections));
        ws.send(this.createMessengerHistoryMessage().toString());
    }

    public void onMessage(WebSocket websocket, String json) {
        System.out.println("onMessage " + json);
        try {
            CSBaseWebSocket ws = (CSBaseWebSocket)websocket;
            Message incomingMessage = new Message(json);
            incomingMessage.setUser(ws.getUser());
            if (incomingMessage.isProjectChange().booleanValue()) {
                Project project;
                Object content = incomingMessage.getContent();
                Project project2 = project = content != null ? new Project((JSONObject)content) : null;
                if (project != ws.getProject()) {
                    ws.setProject(project);
                    connections.put(ws.getUser().getLogin(), ws);
                    Message projectChange = this.createProjectChangeMessage(ws.getUser(), ws.getProject());
                    connections.forEach((userLogin, csBaseWebSocket) -> {
                        if (ws.getProject() != null) {
                            if (ws.getProject().isVisible(csBaseWebSocket.getUser()).booleanValue()) {
                                csBaseWebSocket.send(projectChange.toString());
                            }
                        } else {
                            csBaseWebSocket.send(projectChange.toString());
                        }
                    });
                }
            } else if (incomingMessage.isChat().booleanValue()) {
                UserOutline[] loggedUsers;
                messages.get().add((Object)incomingMessage.toString());
                this.broadcast(incomingMessage);
                UserNotification userNotification = new UserNotification(ws.getUser().getLogin(), incomingMessage.getContent().toString(), false, false);
                csbase.util.messages.Message csbaseMessage = new csbase.util.messages.Message((Serializable)userNotification);
                for (UserOutline loggedUser : loggedUsers = LoginService.getInstance().getLoggedUsers()) {
                    MessageService.getInstance().send(csbaseMessage, loggedUser.getLogin());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Server.logSevereMessage("Erro ao processar mensagem " + json + " enviada por " + (Object)((Object)((CSBaseWebSocket)websocket).getUser()), e);
        }
    }

    public void onPing(WebSocket ws, byte[] bytes) {
        super.onPing(ws, bytes);
        System.out.println("onPing");
    }

    public void onPong(WebSocket ws, byte[] bytes) {
        super.onPong(ws, bytes);
        System.out.println("CSBaseMessenger: onPong");
    }

    public void onClose(WebSocket ws, DataFrame frame) {
        System.out.println("onClose " + frame.toString());
        connections.remove(((CSBaseWebSocket)ws).getUser().getLogin());
        this.broadcast(this.createUserListUpdateMessage(connections));
        messages.save();
    }

    protected boolean onError(WebSocket ws, Throwable t) {
        System.out.println("onError " + t.getLocalizedMessage());
        t.printStackTrace();
        Server.logSevereMessage("CSBaseMessenger onError callback", t);
        return super.onError(ws, t);
    }

    private void broadcast(Message message) {
        System.out.println("Broadcasting " + (Object)((Object)message));
        this.broadcaster.broadcast(connections.values(), message.toString());
    }

    public Message createUserListUpdateMessage(Map<String, CSBaseWebSocket> connections) {
        Message usersOnline = new Message();
        JSONObject projects = new JSONObject();
        if (connections.size() > 0) {
            connections.values().forEach(ws -> {
                String currentProjectId;
                String string = currentProjectId = ws.getProject() != null ? ws.getProject().getId() : "";
                if (projects.has(currentProjectId)) {
                    JSONObject currentProjectUsers = projects.getJSONObject(currentProjectId);
                    currentProjectUsers.put("users", (Object)currentProjectUsers.getJSONArray("users").put((Object)ws.getUser()));
                    projects.put(currentProjectId, (Object)currentProjectUsers);
                } else {
                    JSONObject usersProject = new JSONObject();
                    usersProject.put("users", (Object)new JSONArray().put((Object)ws.getUser()));
                    usersProject.put("project", (Object)ws.getProject());
                    projects.put(currentProjectId, (Object)usersProject);
                }
            });
        }
        usersOnline.setType("ulupd");
        usersOnline.setContent(projects);
        return usersOnline;
    }

    public Message createProjectChangeMessage(User user, Project project) {
        Message projectChange = new Message();
        projectChange.setType("prchg");
        projectChange.setUser(user);
        projectChange.setContent((Object)project);
        return projectChange;
    }

    private Message createMessengerHistoryMessage() {
        JSONArray jsonArray = new JSONArray();
        messages.get().forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        Message history = new Message();
        history.setType("chist");
        history.setContent(jsonArray);
        return history;
    }
}

