/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.exception.ParseException;
import csbase.logic.User;
import csbase.remote.RestServiceInterface;
import csbase.remote.ServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.restservice.CSBaseLoggerHandler;
import csbase.server.services.restservice.CSBaseRequestFilter;
import csbase.server.services.restservice.CSBaseResourceConfig;
import csbase.server.services.restservice.CSBaseResponseFilter;
import csbase.server.services.restservice.CSBaseRuntimeExceptionMapper;
import csbase.server.services.restservice.CSJsonProvider;
import csbase.server.services.restservice.CorsServletFilter;
import csbase.server.services.restservice.websocket.messenger.CSBaseMessenger;
import csbase.server.services.restservice.websocket.notificationcenter.CSBaseNotificationCenter;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.FilterRegistration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class RestService
extends Service
implements RestServiceInterface {
    private HttpServer httpServer;
    private SecretKey privateKey;

    private static URI getBaseURI(int port) {
        return UriBuilder.fromUri((String)"http://0.0.0.0").port(port).path("/").build(new Object[0]);
    }

    protected RestService() throws ServerException {
        super("RestService");
        this.setEnabled(this.getBooleanProperty("enabled"));
    }

    @Override
    protected void initService() throws ServerException {
        this.loadPrivateKey();
        String[] packages = this.loadPackages();
        RestService.buildSwagger(packages);
        final Map<Class<? extends Factory<ServiceInterface>>, Class<?>> factories = this.loadFactories();
        CSBaseResourceConfig config = new CSBaseResourceConfig(packages);
        config.register(new AbstractBinder(){

            protected void configure() {
                factories.forEach((k, v) -> this.bindFactory((Class)k).to((Type)v));
            }
        });
        config.register(ApiListingResource.class);
        config.register(SwaggerSerializers.class);
        config.register(CSBaseRequestFilter.class);
        config.register(CSBaseResponseFilter.class);
        config.register(MultiPartFeature.class);
        config.register(CSJsonProvider.class);
        config.register(JacksonFeature.class);
        config.register(new CSBaseRuntimeExceptionMapper());
        try {
            System.out.println(RestService.getBaseURI(this.getIntProperty("service.port")).toString());
            URI url = RestService.getBaseURI(this.getIntProperty("service.port"));
            this.httpServer = HttpServer.createSimpleServer((String)("http://" + url.getHost()), (int)url.getPort());
            ServletContainer container = new ServletContainer((ResourceConfig)config);
            WebappContext context = new WebappContext("WebappContext", "/v1");
            ServletRegistration registration = context.addServlet("ServletContainer", (Servlet)container);
            registration.addMapping(new String[]{"/*"});
            FilterRegistration corsFilter = context.addFilter("CorsFilter", (Filter)new CorsServletFilter());
            corsFilter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
            this.httpServer.getListener("grizzly").registerAddOn((AddOn)new WebSocketAddOn());
            WebSocketEngine.getEngine().register("", "/messenger", (WebSocketApplication)new CSBaseMessenger());
            WebSocketEngine.getEngine().register("", "/notification", (WebSocketApplication)new CSBaseNotificationCenter());
            this.httpServer.start();
            context.deploy(this.httpServer);
            CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(CSBaseResourceConfig.class.getClassLoader(), new String[]{"swagger-ui/", "docs/"});
            this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/docs"});
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private void loadPrivateKey() throws ServerException {
        String privateKeyFilePath = this.getStringProperty("private.key.file");
        try {
            this.privateKey = this.readKeyFromFile(privateKeyFilePath);
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private String[] loadPackages() throws ServerException {
        List<String> classList = this.getStringListProperty("resources.service.class");
        ArrayList<String> packages = new ArrayList<String>();
        for (String c : classList) {
            try {
                Class<?> cl = Class.forName(c);
                packages.add(cl.getPackage().getName());
                Logger.getLogger(cl.getSimpleName()).addHandler(new CSBaseLoggerHandler());
            }
            catch (ClassNotFoundException e) {
                throw new ServerException("A classe configurada em resources.service.class precisam estar dispon\u00edvel", e);
            }
        }
        return packages.toArray(new String[0]);
    }

    private Map<Class<? extends Factory<ServiceInterface>>, Class<?>> loadFactories() throws ServerException {
        List<String> factorys = this.getStringListProperty("csbase.service.factory");
        List<String> interfaces = this.getStringListProperty("csbase.service.interface");
        if (factorys.size() != interfaces.size()) {
            throw new RuntimeException("A configura\u00e7\u00e3o de csbase.service.interface e csbase.service.factory devem ter o mesmo tamanho");
        }
        HashMap factories = new HashMap();
        for (int i = 0; i < factorys.size(); ++i) {
            try {
                Class<?> factoryClass = Class.forName(factorys.get(i));
                Class<?> interfaceClass = Class.forName(interfaces.get(i));
                factories.put(factoryClass, interfaceClass);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return factories;
    }

    private static void buildSwagger(String[] packageNames) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion("1.0.0");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (String p : packageNames) {
            System.out.println("Package: " + p);
            if (i > 0) {
                builder.append(",");
            }
            builder.append(p.trim());
            ++i;
        }
        beanConfig.setResourcePackage(builder.toString());
        beanConfig.setScan(true);
        beanConfig.setBasePath("/v1");
    }

    @Override
    protected void shutdownService() throws ServerException {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdown();
        }
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    public static void createService() throws ServerException {
        new RestService();
    }

    public static RestService getInstance() {
        return (RestService)RestService.getInstance("RestService");
    }

    public String createToken(String subject, Map<String, Object> attributes, Date expirationDate, Date issuedDate) {
        Claims claims = Jwts.claims();
        if (subject != null) {
            claims.setSubject(subject);
        }
        if (attributes != null) {
            claims.putAll(attributes);
        }
        String token = Jwts.builder().setClaims(claims).setExpiration(expirationDate).setIssuedAt(issuedDate).signWith(SignatureAlgorithm.HS512, (Key)this.privateKey).compact();
        return token;
    }

    public String parserToken(String token, Map<String, Object> outAttributes) throws ParseException {
        String subject = null;
        try {
            AdministrationService adminService;
            User user;
            Claims claims = (Claims)Jwts.parser().setSigningKey((Key)this.privateKey).parseClaimsJws(token).getBody();
            subject = claims.getSubject();
            if (outAttributes != null) {
                outAttributes.putAll((Map<String, Object>)claims);
            }
            if ((user = (adminService = AdministrationService.getInstance()).getUser(subject)) != null) {
                long lastSeconds;
                Date tokenIssued = claims.getIssuedAt();
                Date lastUpdate = new Date(user.getLastUpdate());
                long issueSeconds = tokenIssued.getTime() / 1000L;
                if (issueSeconds - (lastSeconds = lastUpdate.getTime() / 1000L) < 0L) {
                    throw new ParseException(this.getString("RestService.invalid.token.error"));
                }
            }
        }
        catch (Exception e) {
            throw new ParseException(this.getString("RestService.invalid.token.error"));
        }
        return subject;
    }

    public String getExternalURL() {
        return this.getStringProperty("external.url");
    }

    public void logSevereMessage(String msg, Throwable t) {
        Server.logSevereMessage(msg, t);
    }

    public void logInfoMessage(String msg) {
        Server.logInfoMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey readKeyFromFile(String privateKeyFileName) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        try (FileInputStream fis = new FileInputStream(privateKeyFileName);){
            FileChannel channel = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            int size = channel.read(buffer);
            if (size != (int)channel.size()) {
                throw new IOException("N\u00e3o foi poss\u00edvel ler todo o arquivo.");
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(buffer.array(), "HmacSHA512");
            return secretKeySpec;
        }
    }
}

