/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice.websocket;

import csbase.server.Server;
import csbase.server.services.restservice.websocket.CSBaseWebSocket;
import csbase.server.services.restservice.websocket.utils.WebSocketUtils;
import ibase.authentication.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.Broadcaster;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.Extension;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.HandshakeException;
import org.glassfish.grizzly.websockets.OptimizedBroadcaster;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class CSBaseWebSocketApplication
extends WebSocketApplication {
    protected ConcurrentHashMap<String, List<CSBaseWebSocket>> connections = new ConcurrentHashMap();
    protected final Broadcaster broadcaster = new OptimizedBroadcaster();

    public CSBaseWebSocketApplication() {
        System.out.println("Instantiating " + ((Object)((Object)this)).getClass().getSimpleName());
        Server.logInfoMessage("Instanciando " + ((Object)((Object)this)).getClass().getSimpleName());
        WebSocketUtils.InitializeGrizzlyLogger();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> this.connections.values().forEach(userWebSockets -> userWebSockets.forEach(ws -> ws.sendPing(new byte[0]))), 0L, 60L, TimeUnit.SECONDS);
    }

    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
        try {
            CSBaseWebSocket ws = new CSBaseWebSocket(handler, requestPacket, listeners);
            this.connections.compute(ws.getUser().getLogin(), (user, userWebSockets) -> {
                Server.logInfoMessage("Autentica\u00e7\u00e3o com WebSocket " + ((Object)((Object)this)).getClass().getSimpleName() + " pelo usu\u00e1rio " + ws.getUser().getLogin());
                if (userWebSockets == null) {
                    userWebSockets = new ArrayList<CSBaseWebSocket>();
                }
                userWebSockets.add(ws);
                return userWebSockets;
            });
            return ws;
        }
        catch (UnauthorizedException e) {
            e.printStackTrace();
            Server.logSevereMessage("Erro na autentica\u00e7\u00e3o com WebSocket " + ((Object)((Object)this)).getClass().getSimpleName());
            return super.createSocket(handler, requestPacket, listeners);
        }
    }

    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        if (!(socket instanceof CSBaseWebSocket)) {
            Server.logSevereMessage("Fechando WebSocket inv\u00e1lido " + ((Object)((Object)this)).getClass().getSimpleName());
            socket.close(401, "Unauthorized");
        }
    }

    public void onMessage(WebSocket socket, String text) {
        super.onMessage(socket, text);
    }

    public void onMessage(WebSocket socket, byte[] bytes) {
        super.onMessage(socket, bytes);
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        super.onClose(socket, frame);
        if (socket instanceof CSBaseWebSocket) {
            CSBaseWebSocket ws = (CSBaseWebSocket)socket;
            this.connections.compute(ws.getUser().getLogin(), (user, userWebSockets) -> {
                userWebSockets.removeIf(userWebSocket -> userWebSocket.getId().equals(ws.getId()));
                return userWebSockets.size() > 0 ? userWebSockets : null;
            });
        }
    }

    public void onPing(WebSocket socket, byte[] bytes) {
        super.onPing(socket, bytes);
    }

    public void onPong(WebSocket socket, byte[] bytes) {
        super.onPong(socket, bytes);
        System.out.println(((Object)((Object)this)).getClass().getSimpleName() + " onPong");
    }

    protected boolean onError(WebSocket webSocket, Throwable t) {
        System.out.println("onError " + t.getLocalizedMessage());
        t.printStackTrace();
        Server.logSevereMessage(((Object)((Object)this)).getClass().getSimpleName() + " onError callback", t);
        return super.onError(webSocket, t);
    }

    protected boolean add(WebSocket socket) {
        return super.add(socket);
    }

    public boolean remove(WebSocket socket) {
        return super.remove(socket);
    }

    protected Set<WebSocket> getWebSockets() {
        return super.getWebSockets();
    }

    protected void handshake(HandShake handshake) throws HandshakeException {
        super.handshake(handshake);
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        return super.getSupportedProtocols(subProtocol);
    }

    public List<Extension> getSupportedExtensions() {
        return super.getSupportedExtensions();
    }

    public void onExtensionNegotiation(List<Extension> extensions) {
        super.onExtensionNegotiation(extensions);
    }
}

