/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.ftcservice;

import csbase.server.Server;
import csbase.server.services.ftcservice.FTCConfig;
import csbase.server.services.ftcservice.FTCRequester;
import csbase.server.services.ftcservice.FTCService;
import java.io.File;
import java.nio.channels.FileChannel;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.exception.PermissionException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.ftc.server.FileChannelAccessInfo;
import tecgraf.ftc.server.FileServer;
import tecgraf.ftc.server.FileServerConfig;
import tecgraf.ftc.server.FileServerOwner;

class FTCController
implements FileServerOwner {
    private FTCService service = null;
    private FileServerConfig config = null;
    private FileServer server = null;
    private Thread serverThread = null;
    private Thread cleanThread = null;
    private volatile boolean stopped = false;
    private Map<byte[], RequestData> requestMap = null;
    private long remoteFileChannelInfoTimeout = 600000L;
    private SecureRandom secureRandom = null;
    private static final String PRNG_ALGORITHM = "SHA1PRNG";
    private static final int ID_SIZE = 127;

    FTCController(FTCService service) {
        this.service = service;
        this.config = new FTCConfig();
        this.requestMap = new HashMap<byte[], RequestData>();
        try {
            this.secureRandom = SecureRandom.getInstance(PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            this.secureRandom = new SecureRandom();
        }
    }

    void start() throws Exception {
        this.stopped = false;
        this.server = new FileServer((FileServerOwner)this);
        this.serverThread = new Thread(this.service.getName() + " - FTC server"){

            @Override
            public void run() {
                FTCController.this.server.dispatch();
            }
        };
        this.serverThread.start();
        this.cleanThread = new Thread(this.service.getName() + " - FTC cleaner"){

            @Override
            public void run() {
                while (!FTCController.this.stopped) {
                    try {
                        Thread.sleep(FTCController.this.remoteFileChannelInfoTimeout);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    FTCController.this.clean();
                }
            }
        };
        this.cleanThread.start();
        Server.logInfoMessage("FTCController iniciado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        Map<byte[], RequestData> map = this.requestMap;
        synchronized (map) {
            if (this.requestMap.size() == 0) {
                return;
            }
            Iterator<byte[]> it = this.requestMap.keySet().iterator();
            while (it.hasNext()) {
                byte[] id = it.next();
                RequestData data = this.requestMap.get(id);
                if (!data.expired()) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        this.stopped = true;
        this.cleanThread.interrupt();
        this.server.stop();
        Map<byte[], RequestData> map = this.requestMap;
        synchronized (map) {
            this.requestMap.clear();
        }
        try {
            this.serverThread.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Server.logInfoMessage("FTCController finalizado.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestData getRequestData(byte[] fileId) {
        Map<byte[], RequestData> map = this.requestMap;
        synchronized (map) {
            return this.requestMap.get(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(byte[] fileId, boolean remove) {
        RequestData data = this.getRequestData(fileId);
        if (remove) {
            Map<byte[], RequestData> map = this.requestMap;
            synchronized (map) {
                this.requestMap.remove(fileId);
            }
        }
        return data == null ? null : data.file;
    }

    public FileChannel createFileChannel(Object requester, byte[] fileId, boolean readOnly) throws PermissionException, FailureException {
        FileChannel channel = null;
        try {
            RequestData data = this.getRequestData(fileId);
            if (data == null) {
                throw new Exception("Identificador n\u00e3o reconhecido.");
            }
            if (data.readOnly && !readOnly) {
                throw new Exception("Tentativa de escrita em arquivo de leitura: " + data.file.getCanonicalPath());
            }
            channel = ((FTCRequester)requester).createFileChannel(this.getFile(fileId, false), readOnly);
            data.channelOpened = true;
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage(), e);
        }
        return channel;
    }

    public boolean isLocked(Object requester, byte[] fileId) {
        try {
            return ((FTCRequester)requester).isLocked(this.getFile(fileId, false));
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage(), e);
            return false;
        }
    }

    public void fileChannelClosed(Object requester, byte[] fileId) {
        try {
            ((FTCRequester)requester).fileChannelClosed(this.getFile(fileId, true));
        }
        catch (Exception e) {
            Server.logSevereMessage(e.getMessage(), e);
        }
    }

    public FileServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileServerConfig config) {
        this.config = config;
    }

    public void exceptionRaised(Exception e, byte[] fileId) {
        File file = this.getFile(fileId, false);
        String msg = file == null ? "Identificador de arquivo n\u00e3o encontrado: " + Arrays.toString(fileId) : "Falha no acesso ao arquivo " + file.getPath();
        Server.logSevereMessage(msg, e);
    }

    public void exceptionRaised(Exception e) {
        Server.logSevereMessage(e.getMessage(), e);
    }

    private byte[] nextId() {
        byte[] id = new byte[127];
        this.secureRandom.nextBytes(id);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteFileChannelInfo createFileChannelInfo(FTCRequester requester, File file, boolean readOnly) throws Exception {
        byte[] fileId = this.nextId();
        FileChannelAccessInfo srvInfo = this.server.createFileChannelInfo((Object)requester, fileId);
        RequestData data = new RequestData(file, readOnly);
        Map<byte[], RequestData> map = this.requestMap;
        synchronized (map) {
            this.requestMap.put(fileId, data);
        }
        String host = this.service.isPropertyNull("hostName") ? Server.getInstance().getHostName() : this.service.getStringProperty("hostName");
        RemoteFileChannelInfo info = new RemoteFileChannelInfo(srvInfo.getFileIdentifier(), !readOnly, host, srvInfo.getPort(), srvInfo.getAccessKey());
        return info;
    }

    void setRemoteFileChannelInfoTimeout(long remoteFileChannelInfoTimeout) {
        this.remoteFileChannelInfoTimeout = remoteFileChannelInfoTimeout;
    }

    private class RequestData {
        File file;
        boolean readOnly;
        long t0;
        boolean channelOpened;

        RequestData(File file, boolean readOnly) {
            this.file = file;
            this.readOnly = readOnly;
            this.t0 = System.currentTimeMillis();
            this.channelOpened = false;
        }

        boolean expired() {
            if (this.channelOpened) {
                return false;
            }
            long now = System.currentTimeMillis();
            return now - this.t0 > FTCController.this.remoteFileChannelInfoTimeout;
        }
    }
}

