/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.services.sgaservice.ORBException;
import csbase.server.services.sgaservice.ORBHandler;
import csbase.server.services.sgaservice.SGAService;
import csbase.server.services.sgaservice.ssl.SSLContext;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.omg.CORBA.IntHolder;
import org.omg.PortableServer.Servant;
import sgaidl.CompletedCommandInfo;
import sgaidl.InvalidCommandException;
import sgaidl.InvalidParameterException;
import sgaidl.InvalidSGAException;
import sgaidl.NoPermissionException;
import sgaidl.RetrievedInfo;
import sgaidl.SGAAlreadyRegisteredException;
import sgaidl.SGACommand;
import sgaidl.SGACommandOperations;
import sgaidl.SGADaemon;
import sgaidl.SGADaemonOperations;
import sgaidl.SGAManagerPOA;
import sgaidl.SGANotRegisteredException;
import sgaidl.SGAProperties;

public class SGAHandler
extends SGAManagerPOA {
    private SGAService service = null;
    private ORBHandler orbHandler = null;

    public void registerSGA(SGADaemon sga, String sganame, SGAProperties sgaProperties, IntHolder updateInterval) throws NoPermissionException, InvalidParameterException, SGAAlreadyRegisteredException {
        long timeout = this.service.getLongProperty("Timeout");
        String msg = timeout < 0L ? "Timeout na conex\u00e3o com o SGA desativado" : "Timeout para as chamadas ao SGA (seg): " + timeout;
        Server.logInfoMessage(msg);
        if (timeout >= 0L) {
            try {
                this.orbHandler.setTimeOut(sga, timeout);
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro configurando o timeout do SGA: " + sganame, e);
            }
        }
        if (this.service.getBooleanProperty("SSL.enable")) {
            SSLContext inspector = SSLContext.getSSLContext(this._orb());
            String authenticatedSGA = inspector.getContextInformation();
            if (!authenticatedSGA.equals(sganame)) {
                String message = "Negada a conex\u00e3o do SGA {0}: nome informado n\u00e3o \u00e9 igual ao do certificado utilizado.";
                Server.logWarningMessage(MessageFormat.format(message, sganame));
                throw new NoPermissionException();
            }
            if (!this.service.isSGAAuthorized(sganame)) {
                String message = "Negada a conex\u00e3o do SGA {0}: n\u00e3o est\u00e1 na lista de SGAs autorizados.";
                Server.logWarningMessage(MessageFormat.format(message, sganame));
                throw new NoPermissionException();
            }
        }
        this.service.registerSGA((SGADaemonOperations)sga, sganame, sgaProperties, updateInterval);
    }

    public void unregisterSGA(SGADaemon sga, String sganame) throws NoPermissionException, SGANotRegisteredException {
        this.service.unregisterSGA((SGADaemonOperations)sga, sganame);
    }

    public boolean commandCompleted(String sgaName, SGACommand cmd, String cmdId, CompletedCommandInfo info) throws InvalidSGAException, InvalidCommandException, NoPermissionException {
        return this.service.commandCompleted(sgaName, (SGACommandOperations)cmd, cmdId, info);
    }

    public boolean commandLost(String sgaName, String cmdId) throws InvalidSGAException, InvalidCommandException {
        return this.service.commandLost(sgaName, cmdId);
    }

    public boolean commandRetrieved(String sgaName, RetrievedInfo[] cmds) throws InvalidSGAException, NoPermissionException, InvalidCommandException {
        return this.service.commandRetrieved(sgaName, cmds);
    }

    public boolean isRegistered(SGADaemon sga, String sganame) throws InvalidSGAException, NoPermissionException {
        return this.service.isRegistered((SGADaemonOperations)sga, sganame);
    }

    public boolean updateSGAInfo(SGADaemon sga, String sganame, SGAProperties sgaProperties) throws InvalidParameterException, NoPermissionException, SGANotRegisteredException {
        return this.service.updateSGAInfo((SGADaemonOperations)sga, sganame, sgaProperties);
    }

    public SGAHandler(SGAService srv) throws ServerException {
        this.service = srv;
        this.initORB();
    }

    private final void initORB() throws ServerException {
        try {
            Server.logInfoMessage("Acessando ambiente ORB...");
            Properties props = this.service.getExternalPropertyFile("ORB.file");
            if (!this.service.isPropertyNull("ORB.port")) {
                int port = this.service.getIntProperty("ORB.port");
                String portStr = Integer.toString(port);
                props.setProperty("OAPort", portStr);
            }
            if (!this.service.isPropertyNull("ORB.hostAddr")) {
                String addr = this.service.getStringProperty("ORB.hostAddr");
                props.setProperty("OAIAddr", addr);
            }
            if (this.service.getBooleanProperty("SSL.enable")) {
                Properties SSLProps = this.service.getExternalPropertyFile("ORB.SSL.file");
                props.putAll((Map<?, ?>)SSLProps);
                String ks = this.service.getStringProperty("SSL.keystore");
                String ksPass = this.service.getStringProperty("SSL.keystore_password");
                props.setProperty("jacorb.security.keystore", ks);
                props.setProperty("jacorb.security.keystore_password", ksPass);
                this.orbHandler = new ORBHandler(props, true);
            } else {
                this.orbHandler = new ORBHandler(props, false);
            }
            Server.logInfoMessage("Acesso ao ambiente ORB inicializado");
        }
        catch (ORBException e) {
            throw new ServerException("Imposs\u00edvel criar servidor CORBA: " + e.getMessage(), e);
        }
        try {
            String ior = this.orbHandler.activateObject("SGAManager", (Servant)this);
            if (this.service.getBooleanProperty("SSL.enable")) {
                String iorFileName = this.service.getStringProperty("SSL.exported.ior.file");
                Files.write(Paths.get(iorFileName, new String[0]), ior.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            }
        }
        catch (Exception e) {
            throw new ServerException("Imposs\u00edvel criar handler de SGA's", e);
        }
        Server.logInfoMessage("Acesso ao ambiente ORB inicializado");
    }

    public void shutdown() throws ServerException {
        try {
            if (this.orbHandler != null) {
                this.orbHandler.shutdown();
            }
            this.orbHandler = null;
        }
        catch (ORBException e) {
            throw new ServerException("Imposs\u00edvel desativar servidor CORBA", e);
        }
    }
}

