package csbase.server.services.schedulerservice.classadpolicies;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;

public class ClassAdMatchInfo implements Comparable<ClassAdMatchInfo> {

	private SGASet sga;
	private int sgaRank;
	private CommandInfo command;
	private int commandRank;

	private boolean match = false;

	public ClassAdMatchInfo(SGASet sgaSet, CommandInfo cmd, boolean match,
			int cmdRank, int sgaRank) {
		this.sga = sgaSet;
		this.command = cmd;
		this.match = match;
		this.commandRank = cmdRank;
		this.sgaRank = sgaRank;
	}

	public SGASet getSGA() {
		return this.sga;
	}

	public CommandInfo getCommand() {
		return this.command;
	}

	public int getSGARank() {
		return this.sgaRank;
	}

	public int getCmdRank() {
		return this.commandRank;
	}

	public boolean match() {
		return this.match;
	}

	@Override
	public int compareTo(ClassAdMatchInfo o) {
		if (this.command.getPriority().ordinal() > o.command.getPriority()
				.ordinal())
			return -1;
		else if (this.command.getPriority().ordinal() < o.command.getPriority()
				.ordinal())
			return 1;
		else if (this.sgaRank > o.sgaRank)
			return 1;
		else if (this.sgaRank < o.sgaRank)
			return -1;
		else if (this.commandRank > o.commandRank)
			return 1;
		else if (this.commandRank < o.commandRank)
			return -1;
		return 0;
	}
}
