package csbase.server.services.schedulerservice.heuristic;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdResourceController;

public class MaxLoadShufflePolicy implements SchedulerPolicyInterface {

	ClassAdResourceController rController = new ClassAdResourceController();
	AllocationComparatorByPriority allocComp = new AllocationComparatorByPriority();
	CommandGreedinessComparator cmdComp = new CommandGreedinessComparator();

	@Override
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		HeuristicApplyer heuristic = new HeuristicApplyer(cmdComp, allocComp,
				commands, servers, rController);
		Allocation allocation = heuristic.getAllocation();

		// tentar lotar mquinas que estejam com menos recursos disponveis:
		List<CommandInfo> frozenCommands = new LinkedList<CommandInfo>();
		
		int nSGAs = servers.size();
		int nCommands = commands.size();

		for (int i = 0; i < nSGAs; i++) {
			if (frozenCommands.size()==nCommands)
				break;
			List<SGASet> sgaStates = allocation.getServersSimulations();
			Collections.sort(sgaStates, new ResourceDisponibilityComparator());
			SGASet sga = sgaStates.get(i);
			List<CommandInfo> cmdsToSteal = getCommandsToSteal(
					sga, frozenCommands, allocation);
			if (!cmdsToSteal.isEmpty()) {
				Collections.sort(cmdsToSteal, new ResourceDemandComparator());
				for (CommandInfo cmd : cmdsToSteal)
					try {
						sga = allocation.setAllocation(cmd, sga);
					} catch (ImpossibleAllocationException e) {
						break;
					} catch (InvalidSGASetException e) {
						e.printStackTrace();
						// No deveria ocorrer
					}
				frozenCommands.addAll(allocation.getCurrentlyAllocatedCommands(sga));
			}

		}

		return allocation.getPartialAllocationMap();
	}

	private List<CommandInfo> getCommandsToSteal(SGASet server,
			List<CommandInfo> frozenCommands, Allocation alloc) {
		List<CommandInfo> cmdsToSteal = alloc.getPossibleChanges(server);
		// remove frozen commands (cannot be stolen)
		for (CommandInfo cmd : frozenCommands)
			cmdsToSteal.remove(cmd);
		return cmdsToSteal;
	}
}

class ResourceDisponibilityComparator implements Comparator<SGASet> {
	@Override
	public int compare(SGASet o1, SGASet o2) {
		if (o1.getRAMMemoryInfoMb() < o2.getRAMMemoryInfoMb())
			return -1;
		else if (o1.getRAMMemoryInfoMb() > o2.getRAMMemoryInfoMb())
			return 1;
		else if (o1.getNumProcessors() < o2.getNumProcessors())
			return -1;
		else if (o1.getNumProcessors() > o2.getNumProcessors())
			return 1;
		return 0;
	}
}

class ResourceDemandComparator implements Comparator<CommandInfo> {

	@Override
	public int compare(CommandInfo o1, CommandInfo o2) {
		int memory1 = 0, memory2 = 0, cpu1 = 0, cpu2 = 0;
		try {
			AlgorithmConfigurator conf1 = o1.getConfigurator();
			AlgorithmConfigurator conf2 = o2.getConfigurator();
			memory1 = (int) conf1.getMemoryAmount();
			memory2 = (int) conf2.getMemoryAmount();
			cpu1 = (int) conf1.getCpuAmount();
			cpu2 = (int) conf2.getCpuAmount();
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		if (memory1 < memory2)
			return -1;
		else if (memory1 > memory2)
			return 1;
		else if (cpu1 < cpu2)
			return -1;
		else if (cpu1 > cpu2)
			return 1;
		return 0;
	}

}
