/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v2_0;

import csbase.server.Server;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v2_0.LogUtils;
import csbase.server.services.opendreamsservice.opendreams.v2_0.OpenDreamsJobSession;
import csbase.server.services.opendreamsservice.opendreams.v2_0.PersistentMap;
import csbase.server.services.opendreamsservice.opendreams.v2_0.PersistentObject;
import csbase.server.services.schedulerservice.Base32IdGenerator;
import java.io.Serializable;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;
import tecgraf.openbus.DRMAA.v2_0.DrmaaCallback;
import tecgraf.openbus.DRMAA.v2_0.DrmaaCapability;
import tecgraf.openbus.DRMAA.v2_0.InternalException;
import tecgraf.openbus.DRMAA.v2_0.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v2_0.JobSession;
import tecgraf.openbus.DRMAA.v2_0.Version;
import tecgraf.openbus.opendreams.v2_0.IOpenDreamsPOA;

public class SessionManager
extends IOpenDreamsPOA
implements Serializable {
    public static final String UNSET = "indefinido";
    public static final Integer UNSET_INTEGER = 999999999;
    public static final Long UNSET_LONG = 999999999L;
    private static final String JOB_SESSIONS_DIR = "jobsessions";
    private PersistentMap<String, OpenDreamsJobSession> jobSessions = new PersistentMap(PersistentObject.generatePath("jobsessions", "jobsessions.dat"));

    public String drmsName() {
        return Server.getInstance().getSystemName();
    }

    public Version drmsVersion() {
        return new Version("2", "0");
    }

    public String drmaaName() {
        return "Tecgraf CSGrid";
    }

    public Version drmaaVersion() {
        return new Version("DRMAA 2", "OpenDreams 2.0");
    }

    public boolean supports(DrmaaCapability capability) {
        return false;
    }

    public JobSession createJobSession(String sessionName, String contact) throws DeniedByDrmsException, InvalidArgumentException, InternalException {
        String userId = UNSET;
        try {
            Server.logFineMessage("OpenDreams: createJobSession (" + sessionName + ", " + contact + ")");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(userId);
            if (!this.isUnique(sessionName)) {
                throw new InvalidArgumentException("O nome da sess\u00c3\u00a3o (" + sessionName + ") j\u00c3\u00a1 existe.");
            }
            sessionName = sessionName.equals(UNSET) ? this.generateUniqueSessionName(userId) : sessionName;
            contact = contact == null ? UNSET : contact;
            OpenDreamsJobSession session = new OpenDreamsJobSession(sessionName, contact, userId);
            this.jobSessions.put(sessionName, session);
            JobSession jobSession = session.corbaObjectReference();
            return jobSession;
        }
        catch (DeniedByDrmsException e) {
            String msg = "Falha na tentativa de criar uma sess\u00c3\u00a3o do usu\u00c3\u00a1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (InvalidArgumentException e) {
            String msg = "Falha na tentativa de criar uma sess\u00c3\u00a3o do usu\u00c3\u00a1rio " + userId + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro ao criar a sess\u00c3\u00a3o " + sessionName + " do usu\u00c3\u00a1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(LogUtils.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    public JobSession openJobSession(String sessionName) throws InvalidArgumentException, DeniedByDrmsException, InternalException {
        String userId = UNSET;
        try {
            Server.logFineMessage("SessionManager: openJobSession (" + sessionName + ")");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            SessionManager.checkUser(userId);
            if (!this.jobSessions.containsKey(sessionName)) {
                throw new InvalidArgumentException("A sess\u00c3\u00a3o " + sessionName + " n\u00c3\u00a3o existe.");
            }
            OpenDreamsJobSession session = this.jobSessions.get(sessionName);
            session.onResume();
            JobSession jobSession = session.corbaObjectReference();
            return jobSession;
        }
        catch (InvalidArgumentException e) {
            String msg = "Falha na tentativa de obter a sess\u00c3\u00a3o " + sessionName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (DeniedByDrmsException e) {
            String msg = "Falha na tentativa de obter a sess\u00c3\u00a3o " + sessionName + ": " + e.message;
            Server.logWarningMessage(msg);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Falha na tentativa de obter a sess\u00c3\u00a3o " + sessionName + ".";
            Server.logSevereMessage(msg, e);
            throw new InternalException(LogUtils.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    public void closeJobSession(JobSession s) {
    }

    public void destroyJobSession(String sessionName) {
        this.jobSessions.remove(sessionName);
    }

    public String[] getJobSessionNames() {
        return this.jobSessions.keySet().toArray(new String[0]);
    }

    public void registerEventNotification(DrmaaCallback callback) {
    }

    private String generateUniqueSessionName(String userId) {
        return String.format("%s@%s.%s", userId, Server.getInstance().getSystemName(), new Base32IdGenerator().generateId());
    }

    private boolean isUnique(String sessionName) {
        return !this.jobSessions.containsKey(sessionName);
    }

    public static void checkUser(String userId) throws DeniedByDrmsException {
        if (AdministrationService.getInstance().getUser(userId) == null) {
            throw new DeniedByDrmsException("O usu\u00c3\u00a1rio " + userId + " n\u00c3\u00a3o existe.");
        }
    }
}

