package csbase.server.services.diagnosticservice.monitors.openbus;

import java.util.Locale;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Validao do estado do servio de registro do barramento.
 */
public class RegistryServiceValidation implements Validation {
  /** Nome que identifica a validao */
  public static final String NAME = "RegistryServiceValidation";

  /**
   * {@inheritDoc}
   * 
   * Verifica se o servio de registro do barramento foi encontrado.
   */
  @Override
  public ValidationStatus check(Locale locale) {
    if (OpenBusService.getInstance().isRegistryServerActive()) {
      return new ValidationStatus(StatusCode.OK, MessageTranslator.getString(
        "server.openbusmonitor.register.available", locale));
    }
    return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString(
      "server.openbusmonitor.register.unavailable", locale));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String id() {
    return NAME;
  }

  /**
   * {@inheritDoc}
   * 
   * Depende do resultado da validao de {@link ConnectionValidation}.
   */
  @Override
  public String[] requires() {
    return new String[] { ConnectionValidation.NAME };
  }
}
