/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.heuristic;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.heuristic.Allocation;
import csbase.server.services.schedulerservice.heuristic.AllocationStorage;
import csbase.server.services.schedulerservice.heuristic.ResourceControllerInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BruteForceHeuristicApplyer {
    Comparator<CommandInfo> commandComparator;
    Comparator<Allocation> allocationComparator;
    private List<CommandInfo> commands;
    private List<SGASet> servers;
    private List<SGASet> simulatedServers;
    private List<CommandInfo> remainingCommands = new LinkedList<CommandInfo>();
    private HashMap<String, SGASet> originalServers = new HashMap();
    private ResourceControllerInterface manager;
    private Allocation allocation;
    private AllocationStorage storage = new AllocationStorage();
    private boolean foundFeasibleAllocation = false;

    public BruteForceHeuristicApplyer(Comparator<CommandInfo> commandComparator, Comparator<Allocation> allocationComparator, List<CommandInfo> commands, List<SGASet> servers, ResourceControllerInterface manager) {
        this.commandComparator = commandComparator;
        this.allocationComparator = allocationComparator;
        this.commands = commands;
        this.servers = servers;
        this.simulatedServers = new ArrayList<SGASet>(servers);
        this.manager = manager;
        this.applyHeuristic();
    }

    public BruteForceHeuristicApplyer(Comparator<Allocation> allocationComparator, List<CommandInfo> commands, List<SGASet> servers, ResourceControllerInterface manager) {
        this.allocationComparator = allocationComparator;
        this.commands = commands;
        this.servers = servers;
        this.simulatedServers = new ArrayList<SGASet>(servers);
        this.manager = manager;
        this.applyHeuristic();
    }

    private void applyHeuristic() {
        HashMap<CommandInfo, SGASet> currentAllocation = new HashMap<CommandInfo, SGASet>();
        this.remainingCommands.addAll(this.commands);
        for (SGASet sga : this.servers) {
            this.originalServers.put(sga.getName(), sga);
        }
        if (this.chooseCommand(currentAllocation)) {
            this.allocation = new Allocation(currentAllocation, this.simulatedServers, this.remainingCommands, true, this.manager, this.originalServers);
        }
    }

    private boolean chooseCommand(Map<CommandInfo, SGASet> currentAllocationMap) {
        ArrayList<CommandInfo> cmdsCopy = new ArrayList<CommandInfo>(this.remainingCommands);
        if (this.commandComparator != null) {
            Collections.sort(cmdsCopy, this.commandComparator);
        }
        boolean successful = false;
        for (CommandInfo cmd : cmdsCopy) {
            boolean feasible = this.tryCommand(cmd, currentAllocationMap);
            if (!this.foundFeasibleAllocation) {
                successful |= feasible;
                continue;
            }
            if (feasible) continue;
            return false;
        }
        return successful;
    }

    private boolean tryCommand(CommandInfo cmd, Map<CommandInfo, SGASet> currentAllocationMap) {
        this.remainingCommands.remove(cmd);
        List<SGASet> possibleAllocations = this.manager.getServersThatMeetsRequirements(cmd, this.simulatedServers);
        if (possibleAllocations.isEmpty()) {
            System.out.println("No server found for command.");
            Allocation currentAllocation = new Allocation(currentAllocationMap, this.simulatedServers, this.remainingCommands, false, this.manager, this.originalServers);
            if (this.allocation == null || this.allocation.compareTo(currentAllocation) == -1 || this.allocation.compareTo(currentAllocation) == 0 && this.allocationComparator.compare(this.allocation, currentAllocation) == -1) {
                this.allocation = currentAllocation;
            }
            this.remainingCommands.add(cmd);
            return false;
        }
        boolean successful = false;
        for (SGASet sga : possibleAllocations) {
            successful |= this.tryAllocation(currentAllocationMap, cmd, sga);
        }
        this.remainingCommands.add(cmd);
        return successful;
    }

    private boolean tryAllocation(Map<CommandInfo, SGASet> currentAllocationMap, CommandInfo cmd, SGASet server) {
        currentAllocationMap.put(cmd, this.originalServers.get(server.getName()));
        if (!this.storage.hasAllocation(currentAllocationMap)) {
            this.storage.addAllocation(currentAllocationMap);
            SGASet consumedSGA = this.manager.simulateResourceConsumption(cmd, server);
            this.simulatedServers.remove(server);
            this.simulatedServers.add(consumedSGA);
            if (this.remainingCommands.isEmpty()) {
                this.foundFeasibleAllocation = true;
                Allocation currentAllocation = new Allocation(currentAllocationMap, this.simulatedServers, this.remainingCommands, true, this.manager, this.originalServers);
                if (this.allocation == null || this.allocation.compareTo(currentAllocation) == -1 || this.allocation.compareTo(currentAllocation) == 0 && this.allocationComparator.compare(this.allocation, currentAllocation) == -1) {
                    this.allocation = currentAllocation;
                }
            }
            if (this.remainingCommands.isEmpty() || this.chooseCommand(currentAllocationMap)) {
                return true;
            }
            this.simulatedServers.remove(consumedSGA);
            this.simulatedServers.add(server);
            this.manager.undoResourceConsumptionSimulation(cmd, server);
        }
        currentAllocationMap.remove(cmd);
        return false;
    }

    public Allocation getAllocation() {
        return this.allocation;
    }
}

