/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataKeyWrapper;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Faz a validao de dados para o DataService.
 * 
 * @author Tecgraf
 */
public class DataValidation {
  /**
   * Verifica se o usurio  cadastrado no CSBase.
   * 
   * @param userId identificador do usurio
   * @throws DataAccessDenied caso no exista um usurio com o identificador
   */
  public static void checkUser(String userId) throws DataAccessDenied {
    if (AdministrationService.getInstance().getUser(userId) == null) {
      throw new DataAccessDenied(new byte[0][]);
    }
  }

  /**
   * Valida um DataKey.
   * 
   * @param dataKey a DataKey
   * @throws DataNotFound casa o dado referenciado pela DataKey no seja desta
   *         fonte de dados
   */
  public static void checkDataKey(DataKeyWrapper dataKey) throws DataNotFound {
    if (!dataKey.getSystemDeploymentId().equals(
      OpenBusService.getInstance().getEntityName())) {
      throw new DataNotFound(new byte[][] { dataKey.getKey() });
    }

    if (!dataKey.getDataSourceId().equals(
      ProjectDataService.getInstance().SourceId)) {
      throw new DataNotFound(new byte[][] { dataKey.getKey() });
    }
  }
}
