package csbase.server.services.schedulerservice.classadpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;

public class ClassAdPolicy2 implements SchedulerPolicyInterface{
	/*
	 * Segunda implementao de chooseServer: escolhe o melhor SGA para cada
	 * comando, na ordem em que estes aparecerem na ordenao dos matches. No
	 * leva em considerao alocaes anteriores.
	 */
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		ClassAdManager manager = new ClassAdManager();
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
		ArrayList<ClassAdMatchInfo> matches = new ArrayList<ClassAdMatchInfo>();

		for (CommandInfo cmd : commands) {
			matches.addAll(ClassAdPolicyCommons.getMatchedAds(cmd, servers, manager));
		}

		while (!matches.isEmpty()) {
			Collections.sort(matches, Collections.reverseOrder());
			ClassAdMatchInfo winner = matches.get(0);
			CommandInfo commandWinner = winner.getCommand();
			SGASet choosedServer = winner.getSGA();
			allocation.put(commandWinner, choosedServer);
			removeDuplicates(commandWinner, choosedServer, matches);
		}
		return allocation;
	}
	
	private void removeDuplicates(CommandInfo commandWinner, SGASet choosedServer,
			ArrayList<ClassAdMatchInfo> matches) {
		List<ClassAdMatchInfo> toBeRemoved = new ArrayList<ClassAdMatchInfo>();
		for (ClassAdMatchInfo cainfo : matches) {
			if (cainfo.getSGA() == choosedServer
					|| cainfo.getCommand() == commandWinner) {
				toBeRemoved.add(cainfo);
			}
		}
		for (ClassAdMatchInfo cainfo : toBeRemoved)
			matches.remove(cainfo);
	}
}
