package csbase.server.services.schedulerservice.heuristic;

import java.util.List;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;

public interface ResourceControllerInterface {
	public SGASet simulateResourceConsumption(CommandInfo cmd, SGASet server);
	
	public SGASet undoResourceConsumptionSimulation(CommandInfo cmd, SGASet server);
	
	public List<SGASet> getServersThatMeetsRequirements(CommandInfo cmd, List<SGASet> servers);
	
	public List<CommandInfo> getPossibleCommands(List<CommandInfo> commands, SGASet server);
}
