/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.disk;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.logic.diskusageservice.DiskOccupation;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.diskusageservice.DiskUsageService;
import java.util.Locale;

public class DiskOcupationValidation
implements Validation {
    public static final String NAME = "DiskOcupationValidation";

    @Override
    public ValidationStatus check(Locale locale) {
        DiskOccupation serverDiskOccupation = DiskUsageService.getInstance().getAreaOccupation("server");
        if (serverDiskOccupation.getUsedSpacePerc() >= (double)serverDiskOccupation.alertLimit) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.disksmonitor.available.space.warning", new String[]{String.valueOf(serverDiskOccupation.alertLimit)}, locale));
        }
        if (serverDiskOccupation.getUsedSpacePerc() >= (double)serverDiskOccupation.warningLimit) {
            return new ValidationStatus(StatusCode.WARNING, MessageTranslator.getString("server.disksmonitor.available.space.warning", new String[]{String.valueOf(serverDiskOccupation.alertLimit)}, locale));
        }
        return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.disksmonitor.available.space.success", new String[]{String.valueOf(serverDiskOccupation.alertLimit)}, locale));
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return null;
    }
}

