package csbase.server.services.schedulerservice;

import java.util.HashMap;

import csbase.logic.SGASet;

public class QuarantaineRestriction implements SchedulerPolicyRestriction {

	private final HashMap<String, Long> recentUsedServers = new HashMap<String, Long>();
	private long sgaQuarantine;

	public QuarantaineRestriction(long sgaQuarantine) {
		this.sgaQuarantine = sgaQuarantine;
	}

	@Override
	public boolean isSGAAvailable(SGASet server) {
		if (!recentUsedServers.containsKey(server.getName()))
			return true;

		// Verifica se a quarentena j expirou. Nesse caso, retira
		// o SGA da lista e retorna true.
		long now = System.currentTimeMillis();
		if ((sgaQuarantine > 0)
				&& (now - recentUsedServers.get(server.getName()) <= sgaQuarantine)) {
			return false;
		}
		recentUsedServers.remove(server.getName());
		return true;
	}

	public void addToQuarantaine(SGASet server) {
		recentUsedServers.put(server.getName(), System.currentTimeMillis());
	}
}
