/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.classadpolicies;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdManager;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdPolicyCommons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassAdPolicy5
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        ClassAdManager manager = new ClassAdManager();
        HashMap<String, SGASet> originalServers = new HashMap<String, SGASet>();
        ArrayList<SGASet> simulatedServers = new ArrayList<SGASet>(servers);
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        for (SGASet sga : servers) {
            originalServers.put(sga.getName(), sga);
        }
        Collections.sort(commands, Collections.reverseOrder(new CommandGreedinessComparator()));
        for (CommandInfo cmd : commands) {
            List<SGASet> sgas = ClassAdPolicyCommons.getSGAsSortedByDefaultClassAdRank(cmd, servers, manager);
            if (sgas.isEmpty()) continue;
            SGASet sga = sgas.get(0);
            allocation.put(cmd, (SGASet)originalServers.get(sga));
            SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceConsumption(cmd, sga);
            simulatedServers.remove(sga);
            simulatedServers.add(updatedSGA);
            manager.alterSGAAd(updatedSGA);
        }
        return allocation;
    }
}

