/*
 * Decompiled with CFR 0.152.
 */
package csbase.server;

import csbase.remote.TransactionCallbackInterface;
import csbase.remote.TransactionInterface;

public class TransactionManager
implements TransactionInterface {
    private static final long CHECK_LOCK_SLEEP_TIME = 5000L;
    private static final long TRY_LOCK_SLEEP_TIME = 100L;
    private static final long MAX_LOCK_TRIES = 100L;
    private LockValidation checkAlive;
    private TransactionCallbackInterface cb = null;

    public synchronized boolean lock(TransactionCallbackInterface cb) {
        int numTries = 0;
        while (this.isLocked() && (long)numTries++ < 100L) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isLocked()) {
            return false;
        }
        this.cb = cb;
        this.checkAlive = new LockValidation();
        this.checkAlive.start();
        return true;
    }

    public synchronized boolean isLocked() {
        return this.cb != null;
    }

    public synchronized void unlock(TransactionCallbackInterface cb) {
        if (this.cb == null || !this.cb.equals(cb)) {
            throw new Error("TransactionManager:unlock(" + this.cb + "->" + cb + ")");
        }
        this.cb = null;
        this.checkAlive.interrupt();
        this.checkAlive = null;
    }

    private class LockValidation
    extends Thread {
        private LockValidation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionManager transactionManager;
            while (!LockValidation.interrupted()) {
                try {
                    LockValidation.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                transactionManager = TransactionManager.this;
                synchronized (transactionManager) {
                    if (TransactionManager.this.cb == null) {
                        break;
                    }
                    boolean alive = false;
                    try {
                        alive = TransactionManager.this.cb.isAlive();
                    }
                    catch (Exception e) {
                        alive = false;
                    }
                    if (!alive) {
                        TransactionManager.this.cb = null;
                        break;
                    }
                }
            }
            transactionManager = TransactionManager.this;
            synchronized (transactionManager) {
                TransactionManager.this.notifyAll();
            }
        }
    }
}

