package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.Permission;

/**
 * Interface para acesso a dados de permisses de usurios. A criao de objetos
 * que implementam essa interface  responsabilidade da fbrica de DAOs do
 * servio de administrao ({@link AdministrationDAOFactory}}).
 * 
 * @author Jorge Alexandre
 * 
 */
public interface PermissionDAO {

  /**
   * Recupera uma permisso da fonte de dados pelo seu identificador.
   * 
   * @param id identificador da permisso.
   * @return uma referncia para permisso.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  Permission readPermission(Object id) throws DAOException;

  /**
   * Recupera todas as permisso da fonte de dados.
   * 
   * @return uma referncia para a lista de permisses.
   * @throws DAOException se ocorrer algum problema na consulta a fonte de
   *         dados.
   */
  List<Permission> readAllPermissions() throws DAOException;

  /**
   * Persiste a permisso na fonte de dados.
   * 
   * @param permission permisso que ser persistida.
   * @return uma referncia para permisso persistida contendo o seu
   *         identificador.
   * @throws DAOException se ocorrer algum problema na incluso da permisso na
   *         fonte de dados.
   */
  Permission createPermission(Permission permission) throws DAOException;

  /**
   * Modifica uma permisso na fonte de dados.
   * 
   * @param id identificador da permisso.
   * @param permission permisso com as informaes que sero modificadas.
   * @return uma referncia para permisso modificada.
   * @throws DAOException se ocorrer algum problema na modificao da permisso
   *         na fonte de dados.
   */
  Permission modifyPermission(Object id, Permission permission)
    throws DAOException;

  /**
   * Exclui uma permisso na fonte de dados.
   * 
   * @param id identificador da permisso.
   * @throws DAOException se ocorrer algum problema na excluso da permisso na
   *         fonte de dados.
   */
  void deletePermission(Object id) throws DAOException;
}
