package csbase.server.services.opendreamsservice.opendreams.rest;

import csbase.server.services.administrationservice.AdministrationService;
import org.glassfish.jersey.server.ResourceConfig;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;

import javax.inject.Singleton;
import javax.ws.rs.Path;

@Singleton
public class OpenDreams extends ResourceConfig {

	public static class DRMAA2 {
		public enum JobState {
			UNDETERMINED, QUEUED, QUEUED_HELD, RUNNING, SUSPENDED, REQUEUED, REQUEUED_HELD, DONE, FAILED
		}
		public enum OperatingSystem {
			AIX, BSD, LINUX, HPUX, IRIX, MACOS, SUNOS, TRU64, UNIXWARE, WIN, WINNT, OTHER_OS
		}
		public enum CpuArchitecture {
			ALPHA, ARM, ARM64, CELL, PARISC, PARISC64, X86, X64, IA64, MIPS, MIPS64, PPC, PPC64, SPARC, SPARC64, OTHER_CPU
		}
		public enum ResourceLimitType {
			CORE_FILE_SIZE, CPU_TIME, DATA_SIZE, FILE_SIZE, OPEN_FILES, STACK_SIZE, VIRTUAL_MEMORY, WALLCLOCK_TIME
		}
		public enum DrmaaEvent {
			NEW_STATE, MIGRATED, ATTRIBUTE_CHANGE
		}
		public enum DrmaaCapability {
			ADVANCE_RESERVATION, RESERVE_SLOTS, CALLBACK, BULK_JOBS_MAXPARALLEL, JT_EMAIL, JT_STAGING, JT_DEADLINE, JT_MAXSLOTS, JT_ACCOUNTINGID, RT_STARTNOW, RT_DURATION, RT_MACHINEOS, RT_MACHINEARCH
		}
	}

	public static final String API_NAME = "drmaa2";

	public static final int SERVER_PORT = 8080;

	public static final String BASE_URI = "http://localhost:" + SERVER_PORT + "/" + API_NAME + "/";

	public OpenDreams() {
		packages("csbase.server.services.opendreamsservice.opendreams.rest.resources", "io.swagger.jaxrs.listing");
	}

	/**
	 * Verifica se o usuário é cadastrado no CSBase.
	 *
	 * @param userId
	 *            identificador do usuário
	 * @throws DeniedByDrmsException
	 *             caso não exista um usuário com o identificador
	 */
	public static void checkUser(String userId) throws DeniedByDrmsException {
		if (AdministrationService.getInstance().getUser(userId) == null) {
			throw new DeniedByDrmsException("O usuário " + userId + " não existe.");
		}
	}
}
