package csbase.server.services.opendreamsservice.opendreams.rest.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

@Path("jobtemplate")
@Api(value = "/jobtemplate", description = "Job Session RESTful service")
@Produces({"application/json"})
public class JobTemplateResource {
    /**
     * Method handling HTTP GET requests on the /jobtemplate. All job templates must be returned in JSON format.
     *
     * @return All existing job templates.
     */
    @GET
    @ApiOperation(value = "Get all job templates", notes = "Retrieve all existing job templates")
    @Produces(MediaType.APPLICATION_JSON)
    public String getJobTemplates() {
        return "Response";
    }

    /**
     * Method handling HTTP POST requests on /jobtemplate. Create a new job template or return an unsuccessful operation
     * response if the submitted job template was invalid
     *
     * @return Success or failure. //TODO: Determine the response codes associated with the operation outcome.
     */
    @POST
    @ApiOperation(value = "Create job session", notes = "Try to create a new job session using the given name")
    @Consumes(MediaType.APPLICATION_JSON)
    public String createJobTemplate( @ApiParam(value = "Created job template", required = true) JobTemplateResource jt) {
        return "Response";
    }

}
