package csbase.server.services.schedulerservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.sgafilters.SGAFilterByCommandRequirements;

/**
 * Poltica de escalonamento que privilegia os SGAs com maior capacidade atual
 * de processamento, medida obtida pela porcentagem de CPU disponvel juntamente
 * com a capacidade de processamento total da mquina quando no h carga de
 * trabalho.
 * 
 * @author valeria
 *
 */
public class CPUCapacityPolicy implements SchedulerPolicyInterface {
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		BalancedCommandDistribution bdc = new BalancedCommandDistribution(servers);
		
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
		for (CommandInfo cmd : commands) {
			List<SGASet> sgas;

			List<SGASet> filteresSGAs = SGAFilterByCommandRequirements.filter(cmd,
					servers);
			if (filteresSGAs == null) {
				continue;
			}

			sgas = getSortedSGAByCPUCapacity(filteresSGAs);

			if (sgas.size() != 0) {
				SGASet choosedServer = bdc.chooseLightest(sgas);
				allocation.put(cmd, choosedServer);
			}
		}
		return allocation;
	}

	/**
	 * Ordena os SGAs de acordo com a capacidade de processamento atual dos
	 * SGAs, onde se considera o valor retornado do benchmark de CPU e a taxa de
	 * utilizao dessa CPU.
	 * 
	 * @param serversNames
	 *            Os servidores disponveis para execuo
	 * 
	 * @return Lista de servidores ordenados de forma decrescente por capacidade
	 *         atual de processamento
	 */
	private List<SGASet> getSortedSGAByCPUCapacity(List<SGASet> servers) {
		List<SGASet> sgasSets = new ArrayList<SGASet>();
		sgasSets.addAll(servers);
		Collections.sort(sgasSets, new SGASetCPUCapacityComparator());
		return sgasSets;
	}
}
