package csbase.server.services.schedulerservice.sgafilters;

import java.util.List;

import csbase.logic.SGASet;

public class SGACriteriaOr implements SGACriteria {
	
	private List<SGACriteria> criterias;

	public SGACriteriaOr(List<SGACriteria> criterias)
	{
		this.criterias = criterias;
	}
	
	@Override
	public boolean meetCriteria(SGASet server) {
		for (SGACriteria crit: criterias)
		{
			if (crit.meetCriteria(server))
				return true;
		}
		return false;
	}

}
