package csbase.server.services.schedulerservice.sgafilters;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;

public class SGAFilterByCommandRequirements {
	public static List<SGASet> filter(CommandInfo cmd, List<SGASet> servers) {
		try {
			SGACriteria nameCriteria = null;
			SGACriteria platformsCriteria;
			SGACriteria availabilityCriteria;
			SGACriteria binariesCriteria = null;
			SGACriteria minCPUsCriteria = null;
			SGACriteria minMemCriteria = null;
			SGACriteria userPermission;
			
			AlgorithmConfigurator conf = cmd.getConfigurator();
			
			// Filtro pelo nome -> opcional
			String name = cmd.isAutomatic() ? null : cmd.getSGAName();
			if (name != null)
				nameCriteria = new SGACriteriaByName(name);

			// Filtro pela plataforma -> obrigatrio
			String platformRestriction = cmd.getPlatformFilter();
			if (platformRestriction != null)
				platformsCriteria = new SGACriteriaByPlatform(
						platformRestriction);
			else {
				Set<String> platformsSet = conf.getPlatforms();
				List<SGACriteria> criterias = new LinkedList<SGACriteria>();
				for (String platform : platformsSet)
					criterias.add(new SGACriteriaByPlatform(platform));
				platformsCriteria = new SGACriteriaOr(criterias);
			}
			
			// Filtro pela disponibilidade -> obrigatrio
			availabilityCriteria = new SGACriteriaByAvailability();
			
			// Filtro pelos requisitos -> opcional
			Set<String> reqs = conf.getRequirements();
			if (!reqs.isEmpty())
				binariesCriteria = new SGACriteriaByRequirements(reqs);
			
			// Filtro por nmero mnimo de CPUs -> opcional
			float minCPU = conf.getCpuAmount();
			if (minCPU!=0)
				minCPUsCriteria = new SGACriteriaByMinCPUs(minCPU);
			
			// Filtro por quantidade mnima de memria -> opcional
			float minMem = conf.getMemoryAmount();
			if (minMem!=0)
				minMemCriteria = new SGACriteriaByMinFreeRAMMem(minMem);
			
			// Filtro por permisso do usurio
			userPermission = new SGACriteriaByUserPermission(cmd.getUserId());
			
			List<SGACriteria> criteriasToMeet = new LinkedList<SGACriteria>();
			if (nameCriteria!=null)
				criteriasToMeet.add(nameCriteria);
			criteriasToMeet.add(platformsCriteria);
			criteriasToMeet.add(availabilityCriteria);
			if (binariesCriteria!=null)
				criteriasToMeet.add(binariesCriteria);
			if (minCPUsCriteria!=null)
				criteriasToMeet.add(minCPUsCriteria);
			if (minMemCriteria!=null)
				criteriasToMeet.add(minMemCriteria);
			criteriasToMeet.add(userPermission);
			
			SGACriteria finalCriteria = new SGACriteriaAnd(criteriasToMeet);
			return new SGAFilter(finalCriteria).filter(servers);
			
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		return null;
	}
}
