/*
 * Decompiled with CFR 0.152.
 */
package csbase.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class AbstractServlet
extends HttpServlet {
    protected static final String PROPERTIES_DIR = "/WEB-INF";
    protected static final String PROPERTIES_FILE = "System.properties";
    static final String PROP_SERVER_HOST_NAME = "Server.hostName";
    static final String PROP_SERVER_PORT_RMI = "Server.registryPort";
    static final String PROP_SERVER_HOST_ADDR = "Server.hostAddr";
    static final String PROP_CLIENT_PORT_RMI = "Client.port.rmi";
    private static final String DEFAULT_RMI_PORT = "1099";
    private static final String DEFAULT_CLIENT_RMI_PORT = "0";
    private Properties systemProperties;

    AbstractServlet() {
    }

    public void init() throws ServletException {
        try {
            this.loadPropertiesFile();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected String getProperty(String key) {
        return this.systemProperties.getProperty(key);
    }

    protected String getProperty(String key, String defaultValue) {
        return this.systemProperties.getProperty(key, defaultValue);
    }

    protected String getRMIpath() {
        return "rmi://" + this.getServerAddress() + ':' + this.getServerRMIport() + '/';
    }

    protected String getServerName() {
        return this.getProperty(PROP_SERVER_HOST_NAME);
    }

    protected String getServerAddress() {
        return this.getProperty(PROP_SERVER_HOST_ADDR);
    }

    protected String getServerRMIport() {
        return this.getProperty(PROP_SERVER_PORT_RMI, DEFAULT_RMI_PORT);
    }

    protected String getClientRMIport() {
        return this.getProperty(PROP_CLIENT_PORT_RMI, DEFAULT_CLIENT_RMI_PORT);
    }

    protected boolean loadPropertiesFile() {
        String propsPath = "/WEB-INF/System.properties";
        InputStream stream = this.getServletContext().getResourceAsStream(propsPath);
        if (stream == null) {
            this.systemProperties = new Properties();
            return false;
        }
        this.systemProperties = new Properties();
        try {
            this.systemProperties.load(stream);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean hasPropertiesFile() {
        return !this.systemProperties.isEmpty();
    }

    protected abstract void doGet(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
}

