/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga;

import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.sgaservice.ISGADaemon;
import csbase.server.plugin.service.sgaservice.ISGAService;
import csbase.server.plugin.service.sgaservice.SGADaemonException;
import csbase.sga.CommandPersistence;
import csbase.sga.SGALocalCommand;
import csbase.sga.Utils;
import csbase.sga.executor.DefaultJobExecutor;
import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import csbase.sga.monitor.EnvironmentMonitor;
import csbase.sga.monitor.SGAInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.IntHolder;
import sgaidl.CompletedCommandInfo;
import sgaidl.InvalidCommandException;
import sgaidl.InvalidParameterException;
import sgaidl.InvalidPathException;
import sgaidl.InvalidSGAException;
import sgaidl.MissingParameterException;
import sgaidl.NoPermissionException;
import sgaidl.Pair;
import sgaidl.PathNotFoundException;
import sgaidl.RetrievedInfo;
import sgaidl.SGAAlreadyRegisteredException;
import sgaidl.SGACommand;
import sgaidl.SGACommandOperations;
import sgaidl.SGAControlAction;
import sgaidl.SGADaemonOperations;
import sgaidl.SGANotRegisteredException;
import sgaidl.SGAPath;
import sgaidl.SGAProperties;
import sgaidl.SystemException;

public class SGALocal
implements ISGADaemon {
    public static final String SGA_SERVICE_NAME = "SGAService";
    public static final String SGA_MACHINE_TIME_KEY = "csbase_machine_time_seconds";
    public static final String SGA_UPDATE_TIME_KEY = "csbase_update_time_seconds";
    public static final String SGA_PROCESS_TIME_KEY = "csbase_process_time_seconds";
    public static final String SGA_COMPLETED_TIME_KEY = "csbase_completed_time_seconds";
    private static final String SGA_PERSISTENCE_PATH_KEY = "csbase_persistence_path";
    private static final String SGA_LOG_PATH_KEY = "csbase_log_path";
    private static final String SGA_LOG_LEVEL_KEY = "csbase_log_level";
    private static final Level DEFAULT_LOG_LEVEL = Level.INFO;
    protected Properties pluginProperties;
    private ISGAService sgaService;
    private JobExecutor executor;
    private EnvironmentMonitor monitor;
    private Map<String, SGALocalCommand> commands;
    protected Logger logger;
    private TimerExecutor updatePropertiesTask;
    private TimerExecutor checkCompletedCommandsTask;
    private CommandPersistence persistence;
    private String sgaName;
    private String[] defaltConfigKeys = new String[]{"csbase_num_processors", "csbase_memory_ram_info_mb", "csbase_memory_swap_info_mb", "csbase_job_control_actions"};
    private String[] defaltInfoKeys = new String[]{"csbase_load_avg_1min_perc", "csbase_load_avg_5min_perc", "csbase_load_avg_15min_perc", "csbase_memory_ram_free_perc", "csbase_memory_swap_free_perc", "csbase_number_of_jobs"};
    private String[] defaltProcessKeys = new String[]{"csbase_command_pid", "csbase_command_string", "csbase_command_exec_host", "csbase_command_state", "csbase_command_memory_ram_size_mb", "csbase_command_memory_swap_size_mb", "csbase_command_cpu_perc", "csbase_command_wall_time_sec", "csbase_command_user_time_sec", "csbase_command_system_time_sec"};

    public SGALocal(IServiceManager serviceManager) {
        this.sgaService = (ISGAService)ISGAService.class.cast(serviceManager.getService(SGA_SERVICE_NAME));
        this.commands = new ConcurrentHashMap<String, SGALocalCommand>();
    }

    protected void init() {
        try {
            this.setExecutor(new DefaultJobExecutor(this.pluginProperties));
        }
        catch (SGADaemonException e) {
            this.logger.log(Level.SEVERE, "Erro ao iniciar plugin do SGA", e);
            this.stop();
        }
    }

    protected JobExecutor getExecutor() {
        return this.executor;
    }

    protected void setExecutor(JobExecutor executor) {
        this.executor = executor;
    }

    protected EnvironmentMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(EnvironmentMonitor monitor) {
        this.monitor = monitor;
    }

    private synchronized SGAProperties loadSGAProperties() {
        SGAInfo sgaInfo = this.monitor.getSGAInfo();
        SGAProperties sgaProperties = new SGAProperties();
        sgaProperties.properties = this.mapToPair(sgaInfo.properties);
        if (sgaInfo.nodesInfo.size() > 0) {
            sgaProperties.nodesProperties = new Pair[sgaInfo.nodesInfo.size()][];
            for (int j = 0; j < sgaInfo.nodesInfo.size(); ++j) {
                sgaProperties.nodesProperties[j] = this.mapToPair(sgaInfo.nodesInfo.get((int)j).properties);
            }
        } else {
            sgaProperties.nodesProperties = new Pair[1][];
            sgaProperties.nodesProperties[0] = sgaProperties.properties;
        }
        this.logger.finest("Propriedades do SGA: ");
        for (Pair p : sgaProperties.properties) {
            this.logger.finest("\t" + p.key + "=" + p.value);
        }
        this.logger.finest("Propriedades dos n\u00f3s do SGA (" + sgaProperties.nodesProperties.length + ")");
        int j = 0;
        for (Pair[] nodes : sgaProperties.nodesProperties) {
            this.logger.finest("\tN\u00f3 " + j++);
            for (Pair p : nodes) {
                this.logger.finest("\t\t" + p.key + "=" + p.value);
            }
        }
        return sgaProperties;
    }

    private void validatePluginProperties() throws SGADaemonException {
        if (this.pluginProperties == null) {
            throw new SGADaemonException("As propriedades do SGADaemon n\u00e3o foram atribu\u00eddas.");
        }
        if (this.pluginProperties.getProperty("csbase_sga_name") == null) {
            throw new SGADaemonException("A propriedade csbase_sga_name com o nome do SGA n\u00e3o foi definida.");
        }
        if (this.pluginProperties.getProperty(SGA_UPDATE_TIME_KEY) == null) {
            throw new SGADaemonException("A propriedade csbase_update_time_seconds n\u00e3o foi definida.");
        }
        try {
            Integer.parseInt(this.pluginProperties.getProperty(SGA_UPDATE_TIME_KEY));
        }
        catch (NumberFormatException e) {
            throw new SGADaemonException("A propriedade csbase_update_time_seconds possui um valor n\u00e3o num\u00e9rico.", (Throwable)e);
        }
        if (this.pluginProperties.getProperty(SGA_COMPLETED_TIME_KEY) == null) {
            throw new SGADaemonException("A propriedade csbase_completed_time_seconds n\u00e3o foi definida.");
        }
        try {
            Integer.parseInt(this.pluginProperties.getProperty(SGA_COMPLETED_TIME_KEY));
        }
        catch (NumberFormatException e) {
            throw new SGADaemonException("A propriedade csbase_completed_time_seconds possui um valor n\u00e3o num\u00e9rico.", (Throwable)e);
        }
        if (this.pluginProperties.getProperty(SGA_LOG_PATH_KEY) == null) {
            throw new SGADaemonException("A propriedade csbase_log_path n\u00e3o foi definida.");
        }
        File logPath = new File(this.pluginProperties.getProperty(SGA_LOG_PATH_KEY));
        if (!logPath.exists() || !logPath.isDirectory()) {
            throw new SGADaemonException("O diret\u00f3rio defindo na propriedade csbase_log_path n\u00e3o existe ou n\u00e3o \u00e9 diret\u00f3rio.");
        }
        if (this.pluginProperties.getProperty(SGA_PERSISTENCE_PATH_KEY) == null) {
            throw new SGADaemonException("A propriedade csbase_persistence_path n\u00e3o foi definida.");
        }
        if (this.pluginProperties.getProperty("csbase_project_root_directory") == null) {
            throw new SGADaemonException("A propriedade csbase_project_root_directory n\u00e3o foi definida.");
        }
        File projDirPath = new File(this.pluginProperties.getProperty("csbase_project_root_directory"));
        if (!projDirPath.exists() || !projDirPath.isDirectory()) {
            throw new SGADaemonException("O diret\u00f3rio defindo na propriedade csbase_project_root_directory n\u00e3o existe ou n\u00e3o \u00e9 diret\u00f3rio.");
        }
        this.pluginProperties.setProperty("csbase_project_root_directory", projDirPath.getAbsolutePath());
        if (this.pluginProperties.getProperty("csbase_algorithm_root_directory") == null) {
            throw new SGADaemonException("A propriedade csbase_algorithm_root_directory n\u00e3o foi definida.");
        }
        File algoDirPath = new File(this.pluginProperties.getProperty("csbase_algorithm_root_directory"));
        if (!algoDirPath.exists() || !algoDirPath.isDirectory()) {
            throw new SGADaemonException("O diret\u00f3rio defindo na propriedade csbase_algorithm_root_directory n\u00e3o existe ou n\u00e3o \u00e9 diret\u00f3rio.");
        }
        this.pluginProperties.setProperty("csbase_algorithm_root_directory", algoDirPath.getAbsolutePath());
    }

    private synchronized void registerSGA(SGAProperties sgaProps) {
        IntHolder updateInterval = new IntHolder();
        try {
            this.sgaService.registerSGA((SGADaemonOperations)this, this.sgaName, sgaProps, updateInterval);
        }
        catch (InvalidParameterException e) {
            this.logger.log(Level.SEVERE, "Erro ao registrar o SGA: {0}: {1}", new Object[]{e, e.message});
            this.stop();
        }
        catch (NoPermissionException e) {
            this.logger.log(Level.SEVERE, "Erro ao registrar o SGA: {0}: {1}", new Object[]{e, e.message});
            this.stop();
        }
        catch (SGAAlreadyRegisteredException e) {
            this.logger.log(Level.SEVERE, "Erro ao registrar o SGA: {0}: {1}", new Object[]{e, e.message});
            this.stop();
        }
        Map<String, JobData> persistedCommands = this.persistence.getCommands();
        for (String commandId : persistedCommands.keySet()) {
            JobData jobData = persistedCommands.get(commandId);
            SGALocalCommand commandRef = new SGALocalCommand(this.executor, commandId, jobData);
            commandRef.setLogger(this.logger);
            this.commands.put(commandId, commandRef);
            this.logger.log(Level.INFO, "Recuperando comando {0}", new Object[]{commandId});
            commandRef.recovery(jobData, new SynchronizedJobObserver(commandId));
        }
        HashMap<String, JobData> jobsData = new HashMap<String, JobData>();
        LinkedList<RetrievedInfo> infos = new LinkedList<RetrievedInfo>();
        for (String commandId : this.commands.keySet()) {
            SGALocalCommand commandRef = this.commands.get(commandId);
            JobData jobData = commandRef.getJobData();
            jobsData.put(commandId, jobData);
            infos.add(new RetrievedInfo(commandId, (SGACommand)commandRef));
        }
        this.persistence.addCommands(jobsData);
        try {
            this.sgaService.commandRetrieved(this.sgaName, infos.toArray(new RetrievedInfo[infos.size()]));
        }
        catch (InvalidSGAException e) {
            this.logger.log(Level.SEVERE, "Erro ao recuperar comandos: {0}: {1}", new Object[]{e, e.message});
        }
        catch (NoPermissionException e) {
            this.logger.log(Level.SEVERE, "Erro ao recuperar comandos: {0}: {1}", new Object[]{e, e.message});
        }
        catch (InvalidCommandException e) {
            this.logger.log(Level.SEVERE, "Erro ao recuperar comandos: {0}: {1}", new Object[]{e, e.message});
        }
    }

    public SGACommand executeCommand(String commandString, String commandId, Pair[] extraParams) throws SystemException, MissingParameterException {
        this.logger.log(Level.INFO, "Iniciando execu\u00e7\u00e3o do commando {0}.", new Object[]{commandId});
        this.logger.fine("Par\u00e2metros extras:");
        for (Pair pair : extraParams) {
            this.logger.log(Level.FINE, "{0} = {1}.", new Object[]{pair.key, pair.value});
        }
        Map<String, String> paramMap = Utils.convertDicToMap(extraParams);
        SGALocalCommand commandRef = new SGALocalCommand(this.executor, commandId);
        commandRef.setLogger(this.logger);
        this.commands.put(commandId, commandRef);
        commandRef.execute(commandString, paramMap, new SynchronizedJobObserver(commandId));
        return commandRef;
    }

    public void control(SGAControlAction action) {
        this.logger.info("Solicitado " + action.value());
        if (action.equals(SGAControlAction.SHUTDOWN)) {
            try {
                this.sgaService.unregisterSGA((SGADaemonOperations)this, this.sgaName);
            }
            catch (NoPermissionException e) {
                this.logger.log(Level.SEVERE, "Erro ao desregistrar o SGA: {0}: {1}", new Object[]{e, e.message});
            }
            catch (SGANotRegisteredException e) {
                this.logger.log(Level.SEVERE, "Erro ao desregistrar o SGA: {0}: {1}", new Object[]{e, e.message});
            }
            this.stop();
        }
    }

    public SGAPath getPath(String path) throws InvalidPathException, PathNotFoundException {
        return new SGAPath(path, 0.0, true, false, path, true, true, false, true);
    }

    public SGAPath[] getPaths(String root) throws InvalidPathException, PathNotFoundException {
        return null;
    }

    public void ping() {
        this.logger.info("Acesso ao SGA com sucesso.");
    }

    public void setDefaultConfigKeys(String[] keys) {
    }

    public void setDefaultInfoKeys(String[] keys) {
    }

    public void setProperties(Properties pluginProps) {
        this.pluginProperties = pluginProps;
    }

    private Pair[] mapToPair(Map<String, String> map) {
        Pair[] pairs = new Pair[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            pairs[i] = new Pair();
            pairs[i].key = key;
            pairs[i].value = map.get(key);
            ++i;
        }
        return pairs;
    }

    public boolean start() throws SGADaemonException {
        if (this.sgaService == null) {
            throw new SGADaemonException("O servi\u00e7o SGAService est\u00e1 nulo.");
        }
        this.validatePluginProperties();
        this.sgaName = this.pluginProperties.getProperty("csbase_sga_name");
        String logFile = "";
        try {
            if (this.pluginProperties.getProperty(SGA_LOG_PATH_KEY) != null) {
                logFile = this.pluginProperties.getProperty(SGA_LOG_PATH_KEY) + "/" + this.sgaName + ".%g.log";
            }
            this.logger = Logger.getLogger(this.getClass().getName() + "." + this.sgaName);
            FileHandler fh = new FileHandler(logFile, 0xA00000, 10);
            fh.setLevel(DEFAULT_LOG_LEVEL);
            this.logger.addHandler(fh);
            if (this.pluginProperties.getProperty(SGA_LOG_LEVEL_KEY) != null) {
                String logLevel = this.pluginProperties.getProperty(SGA_LOG_LEVEL_KEY);
                this.logger.setLevel(Level.parse(logLevel));
                fh.setLevel(Level.parse(logLevel));
            } else {
                this.logger.setLevel(DEFAULT_LOG_LEVEL);
                fh.setLevel(DEFAULT_LOG_LEVEL);
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            this.logger.setLevel(DEFAULT_LOG_LEVEL);
            this.logger.log(Level.INFO, "Erro ao identificar a propriedade csbase_log_level. Usando n\u00edvel de log padr\u00e3o; " + DEFAULT_LOG_LEVEL.getName(), e);
        }
        catch (IOException | SecurityException e) {
            throw new SGADaemonException("Erro na cria\u00e7\u00e3o do log " + logFile, (Throwable)e);
        }
        this.commands = new Hashtable<String, SGALocalCommand>();
        this.persistence = new CommandPersistence(this.pluginProperties.getProperty(SGA_PERSISTENCE_PATH_KEY) + "/" + this.sgaName + ".dat");
        this.init();
        SGAProperties sgaProps = this.loadSGAProperties();
        if (sgaProps != null && sgaProps.nodesProperties.length > 0) {
            this.registerSGA(sgaProps);
        }
        int updateTime = Integer.parseInt(this.pluginProperties.getProperty(SGA_UPDATE_TIME_KEY));
        this.updatePropertiesTask = new TimerExecutor(updateTime * 1000, new SGAUpdatePropertiesTask());
        this.updatePropertiesTask.start();
        int checkCompletedCommandsInterval = Integer.parseInt(this.pluginProperties.getProperty(SGA_COMPLETED_TIME_KEY));
        this.checkCompletedCommandsTask = new TimerExecutor(checkCompletedCommandsInterval * 1000, new CheckCompletedCommandsTask());
        this.checkCompletedCommandsTask.start();
        this.logger.info("SGADaemon " + this.sgaName + " iniciado");
        return true;
    }

    public void stop() {
        if (this.checkCompletedCommandsTask != null) {
            this.checkCompletedCommandsTask.stop();
        }
        if (this.updatePropertiesTask != null) {
            this.updatePropertiesTask.stop();
        }
        this.logger.info("Finaliza o plugin do SGA.");
    }

    class SynchronizedJobObserver
    implements JobObserver {
        private String commandId;

        SynchronizedJobObserver(String commandId) {
            this.commandId = commandId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onJobCompleted(JobInfo jobInfo) {
            long startTime = System.currentTimeMillis();
            int elapsedTimeSec = Integer.parseInt(jobInfo.jobParam.get("csbase_command_wall_time_sec"));
            int userTimeSec = Integer.parseInt(jobInfo.jobParam.get("csbase_command_user_time_sec"));
            int cpuTimeSec = Integer.parseInt(jobInfo.jobParam.get("csbase_command_time_sec"));
            CompletedCommandInfo completedInfo = new CompletedCommandInfo(elapsedTimeSec, userTimeSec, cpuTimeSec);
            SGALocal.this.logger.log(Level.INFO, "Notificando comado terminado: {0}. [{1}; {2}; {3}]", new Object[]{this.commandId, elapsedTimeSec, userTimeSec, cpuTimeSec});
            SGALocalCommand command = (SGALocalCommand)((Object)SGALocal.this.commands.remove(this.commandId));
            try {
                SGALocal.this.sgaService.commandCompleted(SGALocal.this.sgaName, (SGACommandOperations)command, this.commandId, completedInfo);
            }
            catch (Exception e) {
                SGALocal.this.logger.log(Level.SEVERE, "Erro ao notificar fim do comando {0}. [{1}:{2}]", new Object[]{this.commandId, e, e.getMessage()});
                SGALocal.this.logger.log(Level.FINE, "Exce\u00e7\u00e3o:", e);
            }
            finally {
                SGALocal.this.persistence.removeCommand(this.commandId);
            }
            SGALocal.this.logger.fine("Tempo para notificar t\u00e9rmino do comando: " + (System.currentTimeMillis() - startTime) + " ms");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onJobLost() {
            try {
                SGALocal.this.logger.log(Level.INFO, "Notificando comando perdido: {0}.", new Object[]{this.commandId});
                if (SGALocal.this.commands.containsKey(this.commandId)) {
                    SGALocal.this.commands.remove(this.commandId);
                    SGALocal.this.sgaService.commandLost(SGALocal.this.sgaName, this.commandId);
                }
            }
            catch (Exception e) {
                SGALocal.this.logger.log(Level.SEVERE, "Erro ao notificar o comando perdido: {0}. [{1}:{2}]", new Object[]{this.commandId, e, e.getMessage()});
                SGALocal.this.logger.log(Level.FINE, "Exce\u00e7\u00e3o:", e);
            }
            finally {
                SGALocal.this.persistence.removeCommand(this.commandId);
            }
        }

        @Override
        public synchronized void onJobStarted(JobData jobData) {
            SGALocal.this.logger.log(Level.INFO, "Notificando inicio de execu\u00e7\u00e3o de comado: {0}.", new Object[]{this.commandId});
            if (SGALocal.this.commands.containsKey(this.commandId)) {
                SGALocal.this.persistence.addCommand(this.commandId, jobData);
            }
        }

        @Override
        public void onJobKilled() {
            SGALocal.this.logger.log(Level.INFO, "Notificando interrup\u00e7\u00e3o de execu\u00e7\u00e3o de comado: {0}.", new Object[]{this.commandId});
            if (SGALocal.this.commands.containsKey(this.commandId)) {
                SGALocal.this.persistence.removeCommand(this.commandId);
            }
        }
    }

    private class CheckCompletedCommandsTask
    extends TimerTask {
        private CheckCompletedCommandsTask() {
        }

        @Override
        public void run() {
            SGALocal.this.logger.finest("Buscando comandos finalizados ...");
            SGALocal.this.executor.searchAndNotifyFinishedJobs();
        }
    }

    private class SGAUpdatePropertiesTask
    extends TimerTask {
        private SGAUpdatePropertiesTask() {
        }

        @Override
        public void run() {
            SGALocal.this.logger.finest("Atualiza os dados do SGA  " + SGALocal.this.sgaName);
            SGAProperties sgaProps = SGALocal.this.loadSGAProperties();
            if (sgaProps.nodesProperties.length <= 0) {
                SGALocal.this.logger.log(Level.WARNING, "N\u00e3o existem n\u00f3s de SGAs");
            } else {
                try {
                    if (SGALocal.this.monitor.isAlive()) {
                        if (SGALocal.this.sgaService.isRegistered((SGADaemonOperations)SGALocal.this, SGALocal.this.sgaName)) {
                            SGALocal.this.sgaService.updateSGAInfo((SGADaemonOperations)SGALocal.this, SGALocal.this.sgaName, sgaProps);
                        } else {
                            SGALocal.this.registerSGA(sgaProps);
                        }
                    }
                }
                catch (InvalidParameterException e) {
                    SGALocal.this.logger.log(Level.SEVERE, "Erro ao atualizar as informa\u00e7\u00f5es do SGA: {0}: {1}", new Object[]{e, e.message});
                }
                catch (NoPermissionException e) {
                    SGALocal.this.logger.log(Level.SEVERE, "Erro ao atualizar as informa\u00e7\u00f5es do SGA: {0}: {1}", new Object[]{e, e.message});
                }
                catch (SGANotRegisteredException e) {
                    SGALocal.this.logger.log(Level.SEVERE, "Erro ao atualizar as informa\u00e7\u00f5es do SGA: {0}: {1}", new Object[]{e, e.message});
                }
                catch (InvalidSGAException e) {
                    SGALocal.this.logger.log(Level.SEVERE, "Erro ao atualizar as informa\u00e7\u00f5es do SGA: {0}: {1}", new Object[]{e, e.message});
                }
            }
        }
    }

    private class TimerExecutor {
        private final Timer timer;
        private final int seconds;
        private final TimerTask task;

        protected TimerExecutor(int seconds, TimerTask task) {
            this.seconds = seconds;
            this.task = task;
            this.timer = new Timer();
        }

        protected void start() {
            this.timer.schedule(this.task, this.seconds, (long)this.seconds);
        }

        protected void stop() {
            this.timer.cancel();
        }
    }
}

