/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.rest;

import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.sgaservice.ISGAService;
import csbase.sga.rest.SGARestCommand;
import csbase.sga.rest.SGARestDaemon;
import csbase.sga.rest.messages.parts.PersistentData;
import csbase.sga.rest.messages.parts.RetrievedJob;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.omg.CORBA.IntHolder;
import sgaidl.CompletedCommandInfo;
import sgaidl.InvalidCommandException;
import sgaidl.InvalidParameterException;
import sgaidl.InvalidSGAException;
import sgaidl.NoPermissionException;
import sgaidl.Pair;
import sgaidl.RetrievedInfo;
import sgaidl.SGAAlreadyRegisteredException;
import sgaidl.SGACommandOperations;
import sgaidl.SGADaemonOperations;
import sgaidl.SGANotRegisteredException;
import sgaidl.SGAProperties;

public class CSBaseFacade {
    private ISGAService sgaService;
    private Logger logger;
    private Map<String, DaemonData> daemonData = new HashMap<String, DaemonData>();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private SGARestDaemon getDaemon(String sgaName) {
        DaemonData data = this.daemonData.get(sgaName);
        return data != null ? data.daemon : null;
    }

    public CSBaseFacade(IServiceManager serviceManager) {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.sgaService = (ISGAService)ISGAService.class.cast(serviceManager.getService("SGAService"));
    }

    private Pair[] mapToPairs(Map<String, String> map) {
        Pair[] pairs = new Pair[map.size()];
        int i = 0;
        for (String key : map.keySet()) {
            pairs[i] = new Pair(key, map.get(key));
            ++i;
        }
        return pairs;
    }

    private String tryGet(Map<String, String> map, String field, String def) {
        String value = map.get(field);
        return value != null ? value : def;
    }

    private SGAProperties makeSGAProperties(Map<String, String> sgaProperties, Map<String, Map<String, String>> nodes) {
        if (sgaProperties.get("csbase_file_separator") == null) {
            sgaProperties.put("csbase_file_separator", this.tryGet(sgaProperties, "file_separator", "/"));
        }
        if (sgaProperties.get("csbase_project_root_directory") == null) {
            sgaProperties.put("csbase_project_root_directory", this.tryGet(sgaProperties, "project_root_dir", "/tmp"));
        }
        if (sgaProperties.get("csbase_algorithm_root_directory") == null) {
            sgaProperties.put("csbase_algorithm_root_directory", this.tryGet(sgaProperties, "algorithm_root_dir", "/tmp"));
        }
        if (sgaProperties.get("csbase_sandbox_root_directory") == null) {
            sgaProperties.put("csbase_sandbox_root_directory", this.tryGet(sgaProperties, "sandbox_root_dir", "/tmp"));
        }
        sgaProperties.put("csbase_has_disk_access", "csbase_true");
        Pair[] sgaPropPairs = this.mapToPairs(sgaProperties);
        Pair[][] nodePropPairs = new Pair[nodes.size()][];
        int i = 0;
        for (String nodeName : nodes.keySet()) {
            Map<String, String> nodeProperties = nodes.get(nodeName);
            nodeProperties.put("csbase_name", nodeName);
            nodeProperties.put("csbase_platform_id", this.tryGet(sgaProperties, "platform", "MisconfiguredPlatform"));
            nodeProperties.put("csbase_num_processors", this.tryGet(nodeProperties, "num_of_cpus", "-1"));
            nodeProperties.put("csbase_memory_ram_info_mb", this.tryGet(nodeProperties, "ram_mb", "-1"));
            nodeProperties.put("csbase_memory_swap_info_mb", this.tryGet(nodeProperties, "swap_mb", "-1"));
            nodeProperties.put("csbase_clock_speed_mhz", this.tryGet(nodeProperties, "clock_mhz", "-1"));
            nodeProperties.put("csbase_memory_ram_free_perc", this.tryGet(nodeProperties, "ram_used_perc", "100"));
            nodeProperties.put("csbase_memory_swap_free_perc", this.tryGet(nodeProperties, "swap_used_perc", "100"));
            nodeProperties.put("csbase_number_of_jobs", this.tryGet(nodeProperties, "number_of_jobs", "1"));
            nodeProperties.put("csbase_load_avg_1min_perc", this.tryGet(nodeProperties, "load_avg_1min_perc", "0"));
            nodeProperties.put("csbase_load_avg_5min_perc", this.tryGet(nodeProperties, "load_avg_5min_perc", "0"));
            nodeProperties.put("csbase_load_avg_15min_perc", this.tryGet(nodeProperties, "load_avg_15min_perc", "0"));
            int resourceCount = 1;
            while (sgaProperties.containsKey("resource." + resourceCount)) {
                nodeProperties.put("csbase_resources." + resourceCount, sgaProperties.get("resource." + resourceCount));
                ++resourceCount;
            }
            nodePropPairs[i] = this.mapToPairs(nodeProperties);
            ++i;
        }
        return new SGAProperties(sgaPropPairs, (Pair[][])nodePropPairs);
    }

    private void throwIfRegistered(SGARestDaemon daemon, String sgaName) throws SGAAlreadyRegisteredException {
        boolean ok = true;
        try {
            ok = this.sgaService.isRegistered((SGADaemonOperations)daemon, sgaName);
        }
        catch (Exception e) {
            ok = true;
        }
        if (!ok) {
            throw new SGAAlreadyRegisteredException();
        }
    }

    private void digestStringMap(MessageDigest md, Map<String, String> map) {
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        for (String key : keys) {
            try {
                md.update(key.getBytes("UTF-8"));
                md.update(new byte[]{0});
                md.update(map.get(key).getBytes("UTF-8"));
                md.update(new byte[]{0});
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding UTF-8?! JVM is broken");
            }
        }
    }

    private void digestStringMapMap(MessageDigest md, Map<String, Map<String, String>> map) {
        TreeSet<String> keys = new TreeSet<String>(map.keySet());
        for (String key : keys) {
            try {
                md.update(key.getBytes("UTF-8"));
                md.update(new byte[]{0});
                this.digestStringMap(md, map.get(key));
                md.update(new byte[]{0});
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding UTF-8?! JVM is broken");
            }
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private String hashConfiguration(Map<String, String> sgaProperties, Map<String, Map<String, String>> nodes, Map<String, String> actions) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            this.digestStringMap(md, sgaProperties);
            this.digestStringMapMap(md, nodes);
            this.digestStringMap(md, actions);
            return CSBaseFacade.bytesToHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported algorithm MD5?! JVM is broken");
        }
    }

    private void reportRetrievedJobs(String sgaName, List<RetrievedJob> jobList, SGARestDaemon daemon, boolean isNewDaemon) {
        RetrievedInfo[] retrieved = new RetrievedInfo[jobList.size()];
        int i = 0;
        for (RetrievedJob rjob : jobList) {
            retrieved[i] = new RetrievedInfo();
            retrieved[i].cmdId = rjob.cmd_id;
            SGARestCommand cmdRef = null;
            if (!isNewDaemon) {
                cmdRef = daemon.getCommand(rjob.cmd_id);
                cmdRef.setActions(rjob.actions);
            }
            if (cmdRef == null) {
                cmdRef = daemon.createCommand(rjob.cmd_id, rjob.actions);
            }
            retrieved[i].cmdRef = cmdRef;
            ++i;
        }
        try {
            this.sgaService.commandRetrieved(sgaName, retrieved);
        }
        catch (Exception e) {
            this.logger.severe("Failed reporting retrieved commands for " + sgaName);
        }
    }

    private void reportLostJobs(String sgaName, List<String> cmdIds) {
        for (String cmdId : cmdIds) {
            try {
                this.sgaService.commandLost(sgaName, cmdId);
            }
            catch (Exception e) {
                this.logger.severe("Failed reporting lost command " + cmdId + " for " + sgaName);
            }
        }
    }

    public boolean register(String sgaName, Map<String, String> sgaProperties, Map<String, Map<String, String>> nodes, Map<String, String> actions, PersistentData persistentData) throws InvalidParameterException, NoPermissionException, SGAAlreadyRegisteredException, InvalidSGAException {
        SGARestDaemon daemon = new SGARestDaemon(sgaName, actions);
        String configHash = this.hashConfiguration(sgaProperties, nodes, actions);
        this.logger.fine("SGA config hash: " + configHash);
        DaemonData oldData = this.daemonData.get(sgaName);
        boolean isNewDaemon = true;
        if (oldData != null) {
            if (configHash.equals(oldData.configHash) && this.sgaService.isRegistered((SGADaemonOperations)oldData.daemon, sgaName)) {
                this.logger.fine("SGA was found and configuration is identical. Reuse it.");
                this.throwIfRegistered(oldData.daemon, sgaName);
                daemon = oldData.daemon;
                isNewDaemon = false;
            } else {
                this.logger.info("SGA was found but configuration has changed. Unregister and re-register.");
                try {
                    this.unregister(sgaName);
                }
                catch (SGANotRegisteredException e) {
                    this.daemonData.remove(sgaName);
                }
            }
        }
        IntHolder heartbeatInterval = new IntHolder();
        if (isNewDaemon) {
            try {
                boolean ok = this.sgaService.registerSGA((SGADaemonOperations)daemon, sgaName, this.makeSGAProperties(sgaProperties, nodes), heartbeatInterval);
                this.throwIfRegistered(daemon, sgaName);
                if (!ok) {
                    this.logger.severe("Error registering SGA; CSBase did not specify the error condition.");
                    return false;
                }
            }
            catch (Exception e) {
                this.throwIfRegistered(daemon, sgaName);
                this.logger.severe("Error registering SGA: " + e + ": " + e.getMessage());
                throw e;
            }
        }
        this.reportRetrievedJobs(sgaName, persistentData.retrieved, daemon, isNewDaemon);
        this.reportLostJobs(sgaName, daemon.cleanupJobs(persistentData));
        if (isNewDaemon) {
            daemon.setHeartbeatInterval(heartbeatInterval.value);
            this.daemonData.put(sgaName, new DaemonData(daemon, configHash, sgaProperties));
        }
        return true;
    }

    public void unregister(String sgaName) throws NoPermissionException, SGANotRegisteredException {
        SGARestDaemon daemon = this.getDaemon(sgaName);
        if (daemon == null) {
            throw new SGANotRegisteredException();
        }
        this.sgaService.unregisterSGA((SGADaemonOperations)daemon, sgaName);
        this.daemonData.remove(sgaName);
    }

    public int getHeartbeatInterval(String sgaName) {
        SGARestDaemon daemon = this.getDaemon(sgaName);
        if (daemon == null) {
            return -1;
        }
        return daemon.getHeartbeatInterval();
    }

    public boolean keepAlive(String sgaName) throws InvalidSGAException, NoPermissionException {
        SGARestDaemon daemon = this.getDaemon(sgaName);
        if (daemon == null) {
            return false;
        }
        try {
            boolean ok = this.sgaService.isRegistered((SGADaemonOperations)daemon, sgaName);
            if (!ok) {
                this.daemonData.remove(sgaName);
            }
            return ok;
        }
        catch (Exception e) {
            this.logger.severe("Error in SGA heartbeat: " + e + ": " + e.getMessage());
            throw e;
        }
    }

    public boolean updateStatus(String sgaName, Map<String, Map<String, String>> nodes) throws InvalidParameterException, NoPermissionException, SGANotRegisteredException {
        DaemonData data = this.daemonData.get(sgaName);
        if (data == null) {
            throw new SGANotRegisteredException();
        }
        try {
            this.sgaService.updateSGAInfo((SGADaemonOperations)data.daemon, sgaName, this.makeSGAProperties(data.sgaProperties, nodes));
        }
        catch (Exception e) {
            this.logger.severe("Error updating SGA status: " + e + ": " + e.getMessage());
            throw e;
        }
        return true;
    }

    public boolean commandCompleted(String sgaName, String commandId, int wallTimeSec, int userTimeSec, int systemTimeSec) throws InvalidSGAException, NoPermissionException, InvalidCommandException {
        SGARestDaemon daemon = this.getDaemon(sgaName);
        if (daemon == null) {
            return false;
        }
        SGARestCommand cmd = daemon.removeCommand(commandId);
        return this.sgaService.commandCompleted(sgaName, (SGACommandOperations)cmd, commandId, new CompletedCommandInfo(wallTimeSec, userTimeSec, systemTimeSec));
    }

    private class DaemonData {
        SGARestDaemon daemon;
        String configHash;
        Map<String, String> sgaProperties;

        public DaemonData(SGARestDaemon daemon, String configHash, Map<String, String> sgaProperties) {
            this.daemon = daemon;
            this.configHash = configHash;
            this.sgaProperties = sgaProperties;
        }
    }
}

