package csbase.sga.ssh;

import java.text.MessageFormat;
import java.util.logging.Level;

import csbase.server.plugin.service.IServiceManager;
import csbase.sga.SGALocal;

public class SGASSH extends SGALocal {
  protected static final String SSH_HOST_KEY = "csbase_sga_ssh_host";
  protected static final String SSH_PORT_KEY = "csbase_sga_ssh_port";
  protected static final String SSH_USER_KEY = "csbase_sga_ssh_user";
  protected static final String SSH_PASS_KEY = "csbase_sga_ssh_password";
  protected static final String SSH_PRIVATE_KEY_KEY =
    "csbase_sga_ssh_private_key";
  protected static final String SSH_TUNNEL_ENABLE_KEY =
    "csbase_sga_ssh_tunnel_enable";
  protected static final String SSH_TUNNEL_HOST_KEY =
    "csbase_sga_ssh_tunnel_host";
  protected static final String SSH_TUNNEL_PORT_KEY =
    "csbase_sga_ssh_tunnel_port";
  protected static final String SSH_TUNNEL_USER_KEY =
    "csbase_sga_ssh_tunnel_user";
  protected static final String SSH_TUNNEL_PASS_KEY =
    "csbase_sga_ssh_tunnel_pass";
  protected static final String SSH_TUNNEL_PRIVATE_KEY_KEY =
    "csbase_sga_ssh_tunnel_private_key";
  protected static final String SSH_TUNNEL_LOCAL_PORT_KEY =
    "csbase_sga_ssh_tunnel_local_port";
  protected static final String SSH_TUNNEL_LOCAL_PORT_RANGE_KEY =
    "csbase_sga_ssh_tunnel_local_port_range";

  protected static final String SGA_DRIVER_CLASS_KEY =
    "csbase_sga_ssh_dirver_class";

  private String sshHost;
  private int sshPort;
  private String sshUserName;
  private String sshUserPass;
  private String sshUserPrivKey;
  private boolean isTunnelEnable;
  private String sshTunnelHost;
  private int sshTunnelPort;
  private String sshTunnelUser;
  private String sshTunnelPass;
  private String sshTunnelPrivKey;
  private int sshTunnelLocalPort;
  private int sshTunnelLocalPortRange;

  private SSHClientFactory sshClientFactory;

  public SGASSH(IServiceManager serviceManager) {
    super(serviceManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void init() {
    sshHost = pluginProperties.getProperty(SGASSH.SSH_HOST_KEY);
    sshPort =
      Integer.parseInt(pluginProperties.getProperty(SGASSH.SSH_PORT_KEY));
    sshUserName = pluginProperties.getProperty(SGASSH.SSH_USER_KEY);
    sshUserPass = pluginProperties.getProperty(SGASSH.SSH_PASS_KEY);
    sshUserPrivKey = pluginProperties.getProperty(SGASSH.SSH_PRIVATE_KEY_KEY);

    isTunnelEnable = false;
    String value =
      this.pluginProperties.getProperty(SGASSH.SSH_TUNNEL_ENABLE_KEY);
    if (value != null && (value.equalsIgnoreCase("true")
      || value.equalsIgnoreCase("false"))) {
      isTunnelEnable = Boolean.valueOf(value);
    }
    if (isTunnelEnable) {
      sshTunnelHost = pluginProperties.getProperty(SGASSH.SSH_TUNNEL_HOST_KEY);
      sshTunnelPort =
        Integer.parseInt(
          pluginProperties.getProperty(SGASSH.SSH_TUNNEL_PORT_KEY));
      sshTunnelUser = pluginProperties.getProperty(SGASSH.SSH_TUNNEL_USER_KEY);
      sshTunnelPass = pluginProperties.getProperty(SGASSH.SSH_TUNNEL_PASS_KEY);
      sshTunnelPrivKey =
        pluginProperties.getProperty(SGASSH.SSH_TUNNEL_PRIVATE_KEY_KEY);
      sshTunnelLocalPort =
        Integer.parseInt(
          pluginProperties.getProperty(SGASSH.SSH_TUNNEL_LOCAL_PORT_KEY));
      sshTunnelLocalPortRange =
        Integer.parseInt(
          pluginProperties.getProperty(SGASSH.SSH_TUNNEL_LOCAL_PORT_RANGE_KEY));
    }

    sshClientFactory =
      new SSHClientFactory(sshHost, sshPort, sshUserName, sshUserPass,
        sshUserPrivKey, isTunnelEnable, sshTunnelHost, sshTunnelPort,
        sshTunnelUser, sshTunnelPass, sshTunnelPrivKey, sshTunnelLocalPort,
        sshTunnelLocalPortRange);

    String msg =
      MessageFormat.format(
        "Creating SSH Client Factory: Remote host: [{0} {1} {2} {3} {4}] Tunnel: [{5} {6} {7} {8} {9} {10} {11} {12}]",
        new Object[] { sshHost, sshPort, sshUserName, sshUserPass,
            sshUserPrivKey, isTunnelEnable, sshTunnelHost, sshTunnelPort,
            sshTunnelUser, sshTunnelPass, sshTunnelPrivKey, sshTunnelLocalPort,
            sshTunnelLocalPortRange });

    logger.fine(msg);

    if (pluginProperties.containsKey(SGA_DRIVER_CLASS_KEY)) {
      Class<?> driverClass = null;
      try {
        driverClass =
          Class.forName(pluginProperties.getProperty(SGA_DRIVER_CLASS_KEY));
        SGADriver driver = (SGADriver) driverClass.newInstance();
        driver.init(pluginProperties);

        setExecutor(
          new SSHExecutor(pluginProperties, driver, sshClientFactory));
        setMonitor(new SSHMonitor(pluginProperties, driver, sshClientFactory));
      }
      catch (ClassNotFoundException | InstantiationException
        | IllegalAccessException e) {
        logger.log(Level.SEVERE, "Error during the SGA's initialization", e);
      }
    }
    else {
      logger.log(
        Level.SEVERE, "Mandatory property " + SGA_DRIVER_CLASS_KEY
          + " not defined");

      //TODO Lanar exceo
      return;
    }
  }
}
