/**
 * $Id: SGESAXReader.java 169762 2015-11-13 12:37:30Z fpina $
 */

package csbase.sga.ssh.sge.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author Tecgraf
 */
public class SGESAXReader {
  public List<Map<String, String>> parseCommands(String xml) {
    final List<Map<String, String>> jobs = new LinkedList<>();
    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      DefaultHandler handler = new DefaultHandler() {
        private Map<String, String> currentJob;

        boolean readingJobId = false;
        boolean readingQueueName = false;

        @Override
        public void startElement(String uri, String localName, String qName,
          Attributes attributes) throws SAXException {
          if (qName.equals("job_list")) {
            currentJob = new HashMap<>();
            currentJob.put("state", attributes.getValue("state"));
          }
          else if (qName.equals("JB_job_number")) {
            readingJobId = true;
          }
          else if (qName.equals("queue_name")) {
            readingQueueName = true;
          }
        }

        @Override
        public void endElement(String uri, String localName, String qName)
          throws SAXException {
          if (qName.equals("job_list")) {
            jobs.add(currentJob);
          }
        }

        @Override
        public void characters(char ch[], int start, int length)
          throws SAXException {
          if (readingJobId) {
            currentJob.put("JB_job_number", new String(ch, start, length));
            readingJobId = false;
          }
          if (readingQueueName) {
            String queueName = new String(ch, start, length).trim();
            if (!queueName.isEmpty()) {
              String[] queueAndHost = new String(ch, start, length).split("@");
              currentJob.put("queue", queueAndHost[0]);
              currentJob.put("host", queueAndHost[1]);
            }
            readingQueueName = false;
          }
        }
      };

      saxParser.parse(new ByteArrayInputStream(xml.getBytes()), handler);
    }
    catch (ParserConfigurationException e)

    {
      e.printStackTrace();
    }
    catch (SAXException e)

    {
      e.printStackTrace();
    }
    catch (IOException e)

    {
      e.printStackTrace();
    }

    return jobs;
  }

  public List<Map<String, String>> parseNodes(String xml) {
    final List<Map<String, String>> nodes = new LinkedList<>();
    try {
      SAXParserFactory factory = SAXParserFactory.newInstance();
      SAXParser saxParser = factory.newSAXParser();
      DefaultHandler handler = new DefaultHandler() {
        private Map<String, String> currentNode;

        List<String> queues = null;
        String queueName = null;
        String currentAttribute;
        int nodeSlotsUsed = 0;

        @Override
        public void startElement(String uri, String localName, String qName,
          Attributes attributes) throws SAXException {
          if (qName.equals("host")) {
            currentNode = new HashMap<>();
            currentNode.put("name", attributes.getValue("name"));
            queues = new LinkedList<>();
          }
          else if (qName.equals("hostvalue")) {
            currentAttribute = attributes.getValue("name");
          }
          else if (qName.equals("resourcevalue")) {
            currentAttribute = attributes.getValue("name");
          }
          else if (qName.equals("queue")) {
            queueName = attributes.getValue("name");
            queues.add(queueName);
          }
          else if (qName.equals("queuevalue")) {
            currentAttribute = attributes.getValue("name");
          }
        }

        @Override
        public void endElement(String uri, String localName, String qName)
          throws SAXException {

          if (qName.equals("host")) {
            if (!currentNode.get("name").equals("global")) {
              currentNode.put(
                "total_slots_used", String.valueOf(nodeSlotsUsed));
              currentNode.put("queues", queues.toString());
              nodes.add(currentNode);
              nodeSlotsUsed = 0;
            }
          }
          if (qName.equals("queue")) {
            queueName = null;
          }
        }

        @Override
        public void characters(char ch[], int start, int length)
          throws SAXException {
          if (currentAttribute == null) {
            return;
          }

          switch (currentAttribute) {
            case "arch_string":
              currentNode.put("arch_string", new String(ch, start, length));
              break;
            case "num_proc":
              currentNode.put("num_proc", new String(ch, start, length));
              break;
            case "load_avg":
              currentNode.put("load_avg", new String(ch, start, length));
              break;
            case "mem_total":
              currentNode.put("mem_total", new String(ch, start, length));
              break;
            case "mem_used":
              currentNode.put("mem_used", new String(ch, start, length));
              break;
            case "swap_total":
              currentNode.put("swap_total", new String(ch, start, length));
              break;
            case "swap_used":
              currentNode.put("swap_used", new String(ch, start, length));
              break;
            case "np_load_short":
              currentNode.put("np_load_short", new String(ch, start, length));
              break;
            case "np_load_medium":
              currentNode.put("np_load_medium", new String(ch, start, length));
              break;
            case "np_load_long":
              currentNode.put("np_load_long", new String(ch, start, length));
              break;
            case "slots_used":
              int queueSlotsUsed = 0;
              try {
                queueSlotsUsed =
                  Integer.parseInt(new String(ch, start, length));
              }
              catch (Exception e) {
              }
              nodeSlotsUsed = nodeSlotsUsed + queueSlotsUsed;
              break;
            //            default:
            //              currentNode.put(currentAttribute, new String(ch, start, length));
            //              break;
          }
          currentAttribute = null;
        }
      };

      saxParser.parse(new ByteArrayInputStream(xml.getBytes()), handler);

    }
    catch (ParserConfigurationException e) {
      e.printStackTrace();
    }
    catch (SAXException e) {
      e.printStackTrace();
    }
    catch (IOException e) {
      e.printStackTrace();
    }

    return nodes;
  }
}
