/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sgaidl.ProcessState;

public class JobStorage {
    private long jobInfoMaxAge = 60000L;
    private long lastJobInfoUpdate = 0L;
    private Map<JobData, JobInfo> jobInfoMap = new Hashtable<JobData, JobInfo>();
    private Map<JobData, JobObserver> jobObserverMap = new Hashtable<JobData, JobObserver>();

    public JobStorage() {
        new JobStorage(this.jobInfoMaxAge);
    }

    public JobStorage(long jobInfoMaxAge) {
        this.jobInfoMaxAge = jobInfoMaxAge;
    }

    public synchronized void addJob(JobData data, JobObserver observer) {
        this.jobObserverMap.put(data, observer);
        this.jobInfoMap.put(data, new JobInfo());
    }

    public synchronized boolean addObserver(JobData data, JobObserver observer) {
        if (this.jobInfoMap.containsKey(data)) {
            this.jobObserverMap.put(data, observer);
            return true;
        }
        return false;
    }

    public synchronized JobInfo getJobInfo(JobData data) {
        if (this.jobInfoMap.containsKey(data)) {
            return this.jobInfoMap.get(data);
        }
        return null;
    }

    public synchronized Set<JobData> getJobs() {
        HashSet<JobData> jobs = new HashSet<JobData>();
        jobs.addAll(this.jobObserverMap.keySet());
        jobs.addAll(this.jobInfoMap.keySet());
        return jobs;
    }

    public synchronized void updateJobs(Map<JobData, JobInfo> jobsInfo) {
        this.jobInfoMap.putAll(jobsInfo);
        this.lastJobInfoUpdate = System.currentTimeMillis();
    }

    public synchronized Map<JobObserver, JobInfo> getFinishedJobs() {
        HashMap<JobObserver, JobInfo> finishedJobs = new HashMap<JobObserver, JobInfo>();
        Iterator<Map.Entry<JobData, JobObserver>> it = this.jobObserverMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<JobData, JobObserver> entry = it.next();
            JobData data = entry.getKey();
            JobObserver observer = entry.getValue();
            if (!this.jobInfoMap.containsKey(data)) continue;
            JobInfo info = this.jobInfoMap.get(data);
            if (!((String)info.jobParam.get("csbase_command_state")).equals(ProcessState.FINISHED.toString())) continue;
            finishedJobs.put(observer, info);
            it.remove();
        }
        return finishedJobs;
    }

    public synchronized boolean needsUpdate() {
        return System.currentTimeMillis() - this.lastJobInfoUpdate > this.jobInfoMaxAge;
    }
}

