/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.server.plugin.service.IServiceManager;
import csbase.sga.SGALocal;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.SSHClientFactory;
import csbase.sga.ssh.SSHExecutor;
import csbase.sga.ssh.SSHMonitor;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SGASSH
extends SGALocal {
    protected static final String SSH_HOST_KEY = "csbase_sga_ssh_host";
    protected static final String SSH_PORT_KEY = "csbase_sga_ssh_port";
    protected static final String SSH_USER_KEY = "csbase_sga_ssh_user";
    protected static final String SSH_PASS_KEY = "csbase_sga_ssh_password";
    protected static final String SSH_PRIVATE_KEY_KEY = "csbase_sga_ssh_private_key";
    protected static final String SSH_TUNNEL_ENABLE_KEY = "csbase_sga_ssh_tunnel_enable";
    protected static final String SSH_TUNNEL_HOST_KEY = "csbase_sga_ssh_tunnel_host";
    protected static final String SSH_TUNNEL_PORT_KEY = "csbase_sga_ssh_tunnel_port";
    protected static final String SSH_TUNNEL_USER_KEY = "csbase_sga_ssh_tunnel_user";
    protected static final String SSH_TUNNEL_PASS_KEY = "csbase_sga_ssh_tunnel_pass";
    protected static final String SSH_TUNNEL_PRIVATE_KEY_KEY = "csbase_sga_ssh_tunnel_private_key";
    protected static final String SSH_TUNNEL_LOCAL_PORT_KEY = "csbase_sga_ssh_tunnel_local_port";
    protected static final String SSH_TUNNEL_LOCAL_PORT_RANGE_KEY = "csbase_sga_ssh_tunnel_local_port_range";
    protected static final String SGA_DRIVER_CLASS_KEY = "csbase_sga_ssh_dirver_class";
    private String sshHost;
    private int sshPort;
    private String sshUserName;
    private String sshUserPass;
    private String sshUserPrivKey;
    private boolean isTunnelEnable;
    private String sshTunnelHost;
    private int sshTunnelPort;
    private String sshTunnelUser;
    private String sshTunnelPass;
    private String sshTunnelPrivKey;
    private int sshTunnelLocalPort;
    private int sshTunnelLocalPortRange;
    private SSHClientFactory sshClientFactory;

    public SGASSH(IServiceManager serviceManager) {
        super(serviceManager);
    }

    protected void init() {
        this.sshHost = this.pluginProperties.getProperty(SSH_HOST_KEY);
        this.sshPort = Integer.parseInt(this.pluginProperties.getProperty(SSH_PORT_KEY));
        this.sshUserName = this.pluginProperties.getProperty(SSH_USER_KEY);
        this.sshUserPass = this.pluginProperties.getProperty(SSH_PASS_KEY);
        this.sshUserPrivKey = this.pluginProperties.getProperty(SSH_PRIVATE_KEY_KEY);
        this.isTunnelEnable = false;
        String value = this.pluginProperties.getProperty(SSH_TUNNEL_ENABLE_KEY);
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            this.isTunnelEnable = Boolean.valueOf(value);
        }
        if (this.isTunnelEnable) {
            this.sshTunnelHost = this.pluginProperties.getProperty(SSH_TUNNEL_HOST_KEY);
            this.sshTunnelPort = Integer.parseInt(this.pluginProperties.getProperty(SSH_TUNNEL_PORT_KEY));
            this.sshTunnelUser = this.pluginProperties.getProperty(SSH_TUNNEL_USER_KEY);
            this.sshTunnelPass = this.pluginProperties.getProperty(SSH_TUNNEL_PASS_KEY);
            this.sshTunnelPrivKey = this.pluginProperties.getProperty(SSH_TUNNEL_PRIVATE_KEY_KEY);
            this.sshTunnelLocalPort = Integer.parseInt(this.pluginProperties.getProperty(SSH_TUNNEL_LOCAL_PORT_KEY));
            this.sshTunnelLocalPortRange = Integer.parseInt(this.pluginProperties.getProperty(SSH_TUNNEL_LOCAL_PORT_RANGE_KEY));
        }
        this.sshClientFactory = new SSHClientFactory(this.sshHost, this.sshPort, this.sshUserName, this.sshUserPass, this.sshUserPrivKey, this.isTunnelEnable, this.sshTunnelHost, this.sshTunnelPort, this.sshTunnelUser, this.sshTunnelPass, this.sshTunnelPrivKey, this.sshTunnelLocalPort, this.sshTunnelLocalPortRange);
        String msg = MessageFormat.format("Creating SSH Client Factory: Remote host: [{0} {1} {2} {3} {4}] Tunnel: [{5} {6} {7} {8} {9} {10} {11} {12}]", this.sshHost, this.sshPort, this.sshUserName, this.sshUserPass, this.sshUserPrivKey, this.isTunnelEnable, this.sshTunnelHost, this.sshTunnelPort, this.sshTunnelUser, this.sshTunnelPass, this.sshTunnelPrivKey, this.sshTunnelLocalPort, this.sshTunnelLocalPortRange);
        this.logger.fine(msg);
        if (this.pluginProperties.containsKey(SGA_DRIVER_CLASS_KEY)) {
            Class<?> driverClass = null;
            try {
                driverClass = Class.forName(this.pluginProperties.getProperty(SGA_DRIVER_CLASS_KEY));
                SGADriver driver = (SGADriver)driverClass.newInstance();
                driver.init(this.pluginProperties);
                this.setExecutor(new SSHExecutor(this.pluginProperties, driver, this.sshClientFactory));
                this.setMonitor(new SSHMonitor(this.pluginProperties, driver, this.sshClientFactory));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logger.log(Level.SEVERE, "Error during the SGA's initialization", e);
            }
        } else {
            this.logger.log(Level.SEVERE, "Mandatory property csbase_sga_ssh_dirver_class not defined");
            return;
        }
    }
}

