/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.executor;

import csbase.sga.executor.DefaultJobExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class DirectoryMonitor
implements Runnable {
    static String TIME_SUFIX = ".time";
    static String DONE_SUFIX = ".done";
    private DefaultJobExecutor executor;
    private static Path dir;
    private WatchService watcher;
    private WatchKey watchKey;

    protected DirectoryMonitor(String path, DefaultJobExecutor executor) {
        try {
            this.executor = executor;
            dir = Paths.get(path, new String[0]);
            this.watcher = FileSystems.getDefault().newWatchService();
            this.watchKey = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static String getTimeFile(String jobId) {
        return dir.toString() + File.separator + jobId + TIME_SUFIX;
    }

    protected static String getDoneFile(String jobId) {
        return dir.toString() + File.separator + jobId + DONE_SUFIX;
    }

    protected static void cleanUp(String jobId) {
    }

    @Override
    public void run() {
        while (true) {
            try {
                WatchKey key;
                boolean valid;
                do {
                    key = this.watcher.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                        WatchEvent<?> ev = event;
                        Path path = (Path)ev.context();
                        String[] filename = path.toFile().getName().split("\\.");
                        if (!path.toFile().getName().endsWith(DONE_SUFIX)) continue;
                        this.executor.notifyJobFinished(filename[0]);
                    }
                } while (valid = key.reset());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

