/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.lncc.slurm.v002_006_009;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.lncc.slurm.v002_006_009.SlurmJobData;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sgaidl.ProcessState;

public class SlurmDriver
implements SGADriver {
    private static final String QUEUE_KEY = "sga_slurm_queue";
    private static final String SUBMIT_JOB = "sbatch {0} {1}";
    private static final String CHECK_JOB = "sacct -jk {0} --format=NodeList,State";
    private static final String KILL_JOB = "scancel {0}";
    private static final String CHECK_ALL_HODES_SEPARATOR = "::";
    private static final String CHECK_ALL_NODES = "sinfo -a -N {0} --format=%o::%C";
    private static Pattern JOB_ID_PATTERN = Pattern.compile("[a-zA-Z\\s]*(\\d+)");
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        String cmd = SUBMIT_JOB;
        String extra = "";
        if (this.properties.containsKey(QUEUE_KEY)) {
            extra = extra + " -p " + this.properties.get(QUEUE_KEY);
        }
        String[] data = script.split("\\s");
        return MessageFormat.format(cmd, extra, data[1]);
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        Matcher matcher = JOB_ID_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new SlurmJobData(matcher.group(1));
        }
        return null;
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        String cmd = CHECK_JOB;
        SlurmJobData slurmJobData = (SlurmJobData)jobData;
        return MessageFormat.format(cmd, slurmJobData.getJobId());
    }

    @Override
    public JobInfo parseCheckJobOutput(JobData jobData, String output) {
        JobInfo jobInfo = new JobInfo();
        SlurmJobData slurmJobData = (SlurmJobData)jobData;
        jobInfo.jobParam.put("csbase_command_pid", slurmJobData.getJobId());
        jobInfo.jobParam.put("csbase_command_state", String.valueOf(ProcessState.FINISHED));
        try {
            Scanner sc = new Scanner(output);
            sc.nextLine();
            sc.nextLine();
            String jobAccounting = sc.nextLine();
            String[] data = jobAccounting.split("\\s+");
            String nodelist = data[0].trim();
            jobInfo.jobParam.put("csbase_command_exec_host", nodelist);
            String jobState = data[1].trim();
            ProcessState state = SlurmDriver.convertJobState(jobState);
            jobInfo.jobParam.put("csbase_command_state", String.valueOf(state));
            String ram = "";
            jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", ram);
            String swap = "";
            jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", swap);
            String ctime = "";
            jobInfo.jobParam.put("csbase_command_time_sec", ctime);
            String walltime = "";
            jobInfo.jobParam.put("csbase_command_wall_time_sec", walltime);
            sc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jobInfo;
    }

    private static ProcessState convertJobState(String state) {
        switch (state) {
            case "COMPLETED": {
                return ProcessState.FINISHED;
            }
            case "CANCELLED": {
                return ProcessState.FINISHED;
            }
            case "FAILED": {
                return ProcessState.FINISHED;
            }
            case "NODE_FAIL": {
                return ProcessState.FINISHED;
            }
            case "PREEMPTED": {
                return ProcessState.FINISHED;
            }
            case "TIMEOUT": {
                return ProcessState.FINISHED;
            }
            case "RUNNING": {
                return ProcessState.RUNNING;
            }
            case "RESIZING": {
                return ProcessState.RUNNING;
            }
            case "COMPLETING": {
                return ProcessState.RUNNING;
            }
            case "SUSPENDED": {
                return ProcessState.SLEEPING;
            }
            case "PENDING": {
                return ProcessState.WAITING;
            }
            case "CONFIGURING": {
                return ProcessState.WAITING;
            }
        }
        return ProcessState.WAITING;
    }

    @Override
    public String buildCheckJobListCommand(JobData[] jobDataList) {
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobListOutput(JobData[] jobDataList, String output) {
        return null;
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        String cmd = KILL_JOB;
        SlurmJobData slurmJobData = (SlurmJobData)jobData;
        return MessageFormat.format(cmd, slurmJobData.getJobId());
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        String cmd = CHECK_ALL_NODES;
        String extra = "";
        if (this.properties.containsKey(QUEUE_KEY)) {
            extra = extra + " -p " + this.properties.get(QUEUE_KEY);
        }
        return MessageFormat.format(cmd, extra);
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        SGAInfo sga = new SGAInfo(this.properties);
        Scanner sc = new Scanner(output);
        sc.nextLine();
        while (sc.hasNext()) {
            String nodeInfo = sc.nextLine();
            String[] data = nodeInfo.split(CHECK_ALL_HODES_SEPARATOR);
            String nodeName = data[0].trim();
            String cpuInfo = data[1].trim();
            String[] cpuData = cpuInfo.split("/");
            int cpuAlloc = Integer.parseInt(cpuData[0].trim());
            int cpuIdle = Integer.parseInt(cpuData[1].trim());
            int cpuOther = Integer.parseInt(cpuData[2].trim());
            int cpuTotal = Integer.parseInt(cpuData[3].trim());
            if (cpuAlloc == 0 && cpuIdle == 0) {
                sga.addOffNode(nodeName, null, String.valueOf(cpuTotal), "0", "0", "0");
                continue;
            }
            sga.addNode(nodeName, null, String.valueOf(cpuTotal), "0", "0", "0", "0", "0", "0", "0", "0", String.valueOf(cpuAlloc));
        }
        return sga;
    }
}

