package csbase.sga.ssh.lncc.pbs.v006_000_001;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import sgaidl.COMMAND_CPU_TIME_SEC;
import sgaidl.COMMAND_EXEC_HOST;
import sgaidl.COMMAND_MEMORY_RAM_SIZE_MB;
import sgaidl.COMMAND_MEMORY_SWAP_SIZE_MB;
import sgaidl.COMMAND_PID;
import sgaidl.COMMAND_STATE;
import sgaidl.COMMAND_WALL_TIME_SEC;
import sgaidl.ProcessState;

/**
 * @author SINAPAD
 */
public class PBSDriver implements SGADriver {
	private static final String QUEUE_KEY = "sga_pbs_queue";
	// PBS resource list, eg: nodes=2:ppn=8
	private static final String RESOURCE_LIST = "sga_pbs_resource_list";
	private static final String ENVIRONMENT_CMD = "sga_pbs_environment_cmd";

	private static final String SUBMIT_JOB = "qsub {0} {1}";
	// private static final String CHECK_JOB = "qstat -x {0} 2>/dev/null;echo -n
	// \"{1}\";tracejob -v {2} 2>/dev/null";
	private static final String CHECK_JOB = "qstat -x {0} 2>/dev/null";
	private static final String KILL_JOB = "qdel {0}";
	private static final String CHECK_ALL_NODES_XML = "pbsnodes -x";

	// private static final Pattern TRACEJOB_JOB_PROPERTIES_PATTERN =
	// Pattern.compile("\\s{1}([^\\s]+)=([^\\s]+)\\s{1}");
	// private static final Pattern TRACEJOB_JOB_ID_PATTERN =
	// Pattern.compile("Job: (\\d+)");
	// private static final String CHECK_JOB_CMD_SEPARATOR = "%%";
	// private static final String CHECK_LIST_JOB_CMD_SEPARATOR = "!!";

	private Properties properties;

	@Override
	public void init(Properties properties) {
		this.properties = properties;
	}

	private String configureEnvironment() {
		if (properties.containsKey(ENVIRONMENT_CMD)) {
			return properties.getProperty(ENVIRONMENT_CMD) + ";";
		}
		return "";
	}

	@Override
	public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
		String cmd = configureEnvironment() + SUBMIT_JOB;
		String extra = "";
		if (properties.containsKey(QUEUE_KEY)) {
			extra += " -q " + properties.get(QUEUE_KEY);
		}
		if (properties.contains(RESOURCE_LIST)) {
			extra += " -l " + properties.get(RESOURCE_LIST);
		}
		String[] splitedScript = script.split("\\s");

		return MessageFormat.format(cmd, extra, splitedScript[1]);
	}

	@Override
	public JobData parseJobSubmissionOutput(String output) {
		if (output != null && !output.isEmpty()) {
			if (output.contains(".")) {
				output = output.substring(0, output.indexOf("."));
			}
			return new PBSJobData(output);
		}
		return null;
	}

	@Override
	public String buildKillJobCommand(JobData jobData) {
		String cmd = configureEnvironment() + KILL_JOB;
		PBSJobData data = (PBSJobData) jobData;
		return MessageFormat.format(cmd, data.getJobId());
	}

	@Override
	public String buildCheckJobCommand(JobData jobData) {
		String cmd = configureEnvironment() + CHECK_JOB;
		PBSJobData data = (PBSJobData) jobData;
		// return MessageFormat.format(cmd, data.getJobId(),
		// CHECK_JOB_CMD_SEPARATOR, data.getJobId());
		return MessageFormat.format(cmd, data.getJobId());
	}

	@Override
	public JobInfo parseCheckJobOutput(JobData jobData, String output) {
		// String[] data = output.split(CHECK_JOB_CMD_SEPARATOR);
		// String qstat = data[0].trim();
		// String tracejob = data[1].trim();

		JobInfo jobInfo = new JobInfo();
		if (output != null && !output.isEmpty()) {
			Document doc = Jsoup.parse(output, "", Parser.xmlParser());
			// retrieving PBS job id
			{
				Elements elements = doc.select("data").select("job").select("Job_Id");
				if (elements.size() == 1) {
					String jobId = elements.get(0).text();
					// get only the jobid
					if (jobId.contains(".")) {
						jobId = jobId.substring(0, jobId.indexOf("."));
					}
					jobInfo.jobParam.put(COMMAND_PID.value, jobId);
				}
			}
			// retrieving PBS exec hosts
			{
				Elements elements = doc.select("data").select("job").select("exec_host");
				if (elements.size() == 1) {
					String execHost = elements.get(0).text();
					jobInfo.jobParam.put(COMMAND_EXEC_HOST.value, execHost);
				}
			}
			// retrieving PBS job status
			{
				Elements elements = doc.select("data").select("job").select("job_state");
				if (elements.size() == 1) {
					String jobState = elements.get(0).text();
					ProcessState state = convertJobState(jobState);
					jobInfo.jobParam.put(COMMAND_STATE.value, String.valueOf(state));
				}
			}
			{
				Elements elements = doc.select("data").select("job").select("resources_used");
				long ram = -1;
				long swap = -1;
				long ctime = -1;
				long walltime = -1;
				if (elements.size() == 1) {
					Element e = elements.get(0);
					{
						Elements info = e.select("mem");
						if (info.size() == 1) {
							String str = info.text();
							ram = getInfoInMb(str);
						}
					}
					{
						Elements info = e.select("vmem");
						if (info.size() == 1) {
							String str = info.text();
							swap = getInfoInMb(str);
						}
					}
					{
						Elements info = e.select("cput");
						if (info.size() == 1) {
							String str = info.text();
							ctime = getInfoInSec(str);
						}
					}
					{
						Elements info = e.select("walltime");
						if (info.size() == 1) {
							String str = info.text();
							walltime = getInfoInSec(str);
						}
					}

				}
				jobInfo.jobParam.put(COMMAND_MEMORY_RAM_SIZE_MB.value, Long.toString(ram));
				jobInfo.jobParam.put(COMMAND_MEMORY_SWAP_SIZE_MB.value, Long.toString(swap));
				jobInfo.jobParam.put(COMMAND_CPU_TIME_SEC.value, Long.toString(ctime));
				jobInfo.jobParam.put(COMMAND_WALL_TIME_SEC.value, Long.toString(walltime));

			}
			/*
			 * } else if (!tracejob.isEmpty()) { String jobId = ""; Matcher
			 * jobIdMatcher = TRACEJOB_JOB_ID_PATTERN.matcher(tracejob); if
			 * (jobIdMatcher.find()) { jobId = jobIdMatcher.group(1); } if (jobId !=
			 * null && !jobId.isEmpty()) { Matcher matcher =
			 * TRACEJOB_JOB_PROPERTIES_PATTERN.matcher(tracejob); int start = 0;
			 * Map<String, String> properties = new HashMap<String, String>(); while
			 * (matcher.find(start)) { String key = matcher.group(1); String value =
			 * matcher.group(2); properties.put(key, value); start = matcher.start() +
			 * 1; }
			 * 
			 * jobInfo.jobParam.put(COMMAND_PID.value, jobId);
			 * jobInfo.jobParam.put(COMMAND_STATE.value,
			 * String.valueOf(ProcessState.FINISHED)); String host =
			 * properties.get("exec_host");
			 * jobInfo.jobParam.put(COMMAND_EXEC_HOST.value, (host == null) ? "" :
			 * host); String ctimeS = properties.get("resources_used.cput"); String
			 * ramS = properties.get("resources_used.mem"); String swapS =
			 * properties.get("resources_used.vmem"); String walltimeS =
			 * properties.get("resources_used.walltime");
			 * 
			 * long ram = (ramS != null) ? getInfoInMb(ramS) : -1; long swap = (swapS
			 * != null) ? getInfoInMb(swapS) : -1; long ctime = (ctimeS != null) ?
			 * Long.parseLong(ctimeS) : -1; long walltime = (walltimeS != null) ?
			 * Long.parseLong(walltimeS) : -1;
			 * 
			 * jobInfo.jobParam.put(COMMAND_MEMORY_RAM_SIZE_MB.value,
			 * Long.toString(ram));
			 * jobInfo.jobParam.put(COMMAND_MEMORY_SWAP_SIZE_MB.value,
			 * Long.toString(swap)); jobInfo.jobParam.put(COMMAND_CPU_TIME_SEC.value,
			 * Long.toString(ctime));
			 * jobInfo.jobParam.put(COMMAND_WALL_TIME_SEC.value,
			 * Long.toString(walltime)); }
			 */
		} else {
			if (jobData != null) {
				jobInfo.jobParam.put(COMMAND_PID.value, ((PBSJobData) jobData).getJobId());
			}
			jobInfo.jobParam.put(COMMAND_STATE.value, String.valueOf(ProcessState.FINISHED));
		}
		return jobInfo;
	}

	private static ProcessState convertJobState(String state) {
		switch (state) {

		case "C": // Job is completed after having run
			return ProcessState.FINISHED;
		case "E": // Job is exiting after having run
			return ProcessState.FINISHED;
		case "H": // Job is held
			return ProcessState.SLEEPING;
		case "Q": // job is queued, eligible to run or routed
			return ProcessState.WAITING;
		case "R": // job is running
			return ProcessState.RUNNING;
		case "T": // job is being moved to new location
			return ProcessState.RUNNING;
		case "W": // job is waiting for its execution time (-a option) to be
			// reached.
			return ProcessState.SLEEPING;
		case "S": // (Unicos only) job is suspend
			return ProcessState.FINISHED;
		default:
			return ProcessState.WAITING;
		}
	}

	@Override
	public String buildCheckJobListCommand(JobData[] jobDataList) {
		return null;
		/*
		 * String cmd = ""; if (jobDataList != null) { for (JobData job :
		 * jobDataList) { cmd += buildCheckJobCommand(job) + ";echo -n \"" +
		 * CHECK_LIST_JOB_CMD_SEPARATOR + "\";"; } } return cmd;
		 */
	}

	@Override
	public Map<JobData, JobInfo> parseCheckJobListOutput(JobData[] jobDataList, String output) {
		return null;
		/*
		 * Map<JobData, JobInfo> map = new HashMap<JobData, JobInfo>();
		 * Arrays.sort(jobDataList); String[] data =
		 * output.split(CHECK_LIST_JOB_CMD_SEPARATOR); for (String d : data) { if
		 * (!d.isEmpty()) { JobInfo jobInfo = parseCheckJobOutput(null, d); String
		 * jobId = jobInfo.jobParam.get(COMMAND_PID.value); if (jobId != null) {
		 * PBSJobData jobData = new PBSJobData(jobId); int index =
		 * Arrays.binarySearch(jobDataList, jobData); if (index >= 0) {
		 * map.put(jobDataList[index], jobInfo); } } } } if (map.size() <
		 * jobDataList.length) { // will check for "job leak" for (JobData jobData :
		 * jobDataList) { if (!map.containsKey(jobData)) { JobInfo jobInfo = new
		 * JobInfo(); jobInfo.jobParam.put(COMMAND_PID.value, ((PBSJobData)
		 * jobData).getJobId()); jobInfo.jobParam.put(COMMAND_STATE.value,
		 * String.valueOf(ProcessState.FINISHED));
		 * 
		 * map.put(jobData, jobInfo); } } } return map;
		 */
	}

	@Override
	public String buildCheckEnvironmentCommand() {
		String cmd = configureEnvironment() + CHECK_ALL_NODES_XML;
		if (properties.containsKey(QUEUE_KEY)) {
			cmd += " :" + properties.get(QUEUE_KEY);
		}
		return cmd;
	}

	@Override
	public SGAInfo parseCheckEnvironmentOutput(String output) {
		SGAInfo sga = new SGAInfo(properties);
		Document doc = Jsoup.parse(output, "", Parser.xmlParser());
		// retrieving PBS nodes
		Elements elements = doc.select("data").select("node");
		for (int i = 0; i < elements.size(); i++) {
			Element e = elements.get(i);

			String name = null;
			String ncpus = null;
			long ramMem = -1;
			long swapMem = -1;
			long availableRam = -1;
			long availableSwap = -1;
			double freeRamPerc = -1;
			double freeSwapPerc = -1;
			String loadave = null;
			int njobs = 0;
			{
				Elements element = e.select("name");
				if (element.size() == 1) {
					name = element.get(0).text();
				}
			}

			{
				Elements element = e.select("status");
				if (element.size() == 1) {
					Map<String, String> map = new HashMap<String, String>();
					String text = element.get(0).text();
					Pattern NODES_ATTRIBUTES_PATTERN = Pattern.compile("([^,=]+)=([^,]+)");
					Matcher attrsMatcher = NODES_ATTRIBUTES_PATTERN.matcher(text);
					while (attrsMatcher.find()) {
						if (!map.containsKey(attrsMatcher.group(1))) {
							map.put(attrsMatcher.group(1), attrsMatcher.group(2));
						}
					}

					ncpus = map.get("ncpus");
					long physmemkb = getInfoInMb(map.get("physmem"));
					ramMem = physmemkb;
					long totmemkb = getInfoInMb(map.get("totmem"));
					swapMem = totmemkb - physmemkb;
					long availmemkb = getInfoInMb(map.get("availmem"));
					availableRam = availmemkb >= (swapMem) ? availmemkb - swapMem : 0;
					availableSwap = availmemkb - availableRam;
					freeRamPerc = availableRam * 100 / ramMem;
					if (swapMem > 0) {
						freeSwapPerc = availableSwap * 100 / swapMem;
					}
					loadave = map.get("loadave");

					Pattern JOB_IDS_PATTERN = Pattern.compile("([^,(]+)");
					if (map.containsKey("jobs")) {
						Matcher jobsMatcher = JOB_IDS_PATTERN.matcher(map.get("jobs"));
						while (jobsMatcher.find()) {
							Elements jobs = e.select("jobs");
							// caso a tag jobs exista e porque o job abriu novas threads
							if (!jobs.isEmpty()) {
								String jobId = jobsMatcher.group(1);
								// conta quantas threads daquele job com id, padrão: X/jobId
								// Pattern JOB_THREADS_PATTERN = Pattern.compile("(\\d+/" +
								// jobId + ")");
								Pattern JOB_THREADS_PATTERN = Pattern.compile("(\\d+)[-|](\\d+)/" + jobId);
								if (jobs.size() == 1) {
									Matcher jobThreadsMatcher = JOB_THREADS_PATTERN.matcher(jobs.get(0).text());
									if (jobThreadsMatcher.find()) {
										int a = Integer.parseInt(jobThreadsMatcher.group(1));
										int b = Integer.parseInt(jobThreadsMatcher.group(2));
										njobs = ((b - a) + 1);
									} else {
										njobs++;
									}
								}
							} else {
								njobs++;
							}
						}
					}
				}
			}

			sga.addNode(name, null, ncpus, "0", Long.toString(ramMem), Long.toString(swapMem), Double.toString(freeRamPerc), Double.toString(freeSwapPerc), loadave, loadave, loadave, String.valueOf(njobs));
		}
		return sga;
	}

	private long getInfoInMb(String string) {
		Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+)(\\S+)");
		Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
		attrsMatcher.find();
		long value = Long.parseLong(attrsMatcher.group(1));
		String measure = attrsMatcher.group(2);
		switch (measure) {
		case "b":
			value /= 1000000;
			break;
		case "kb":
			value /= 1000;
			break;
		case "mb":
			break;
		case "gb":
			value *= 1000;
			break;
		case "tb":
			value *= 1000000;
			break;
		default:
			value = 0;
			break;

		}

		return value;
	}

	private long getInfoInSec(String string) {
		Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+)");
		Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
		attrsMatcher.find();
		return Long.parseLong(attrsMatcher.group(1)) * 3600 + Long.parseLong(attrsMatcher.group(2)) * 60 + Long.parseLong(attrsMatcher.group(3));
	}
}
