package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Classe de mtodos utilitrios para os testes unitrios.
 * 
 * @author Tecgraf
 */
public class TestUtils {
  /** Tamanho do buffer de transferncia para cpia de arquivos. */
  private static final int BUFFER_SIZE = 1024;
  
  /** Definio do separador de arquivos, que no deve ser dependente da plataforma. */
  public static final String FILE_SEPARATOR = "/";

  /** Diretrio-raiz para os dados usados nos testes. */
  private static final String DATA_HOME = "test" + FILE_SEPARATOR + "data";

  /**
   * Retorna o diretrio onde se encontram os dados para a classe especificada.
   * O caminho segue a estrutura do pacote da classe, dentro do diretrio raiz
   * de dados.
   * 
   * @param testClass classe de testes que deseja fazer acesso a dados.
   * 
   * @return diretrio de dados para este teste.
   */
  public static String getDataDir(Class testClass) {
    StringBuilder dir = new StringBuilder(DATA_HOME);
    dir.append(FILE_SEPARATOR);
    String packageName = testClass.getPackage().getName();
    String resolvedPackage =
      packageName.replaceAll("\\.", "\\" + FILE_SEPARATOR);
    dir.append(resolvedPackage);
    dir.append(FILE_SEPARATOR);
    return dir.toString();
  }

  /**
   * Copia um arquivo.
   * 
   * @param src arquivo de origem.
   * @param dst arquivo de destino.
   * 
   * @throws IOException
   */
  public static void copy(File src, File dst) throws IOException {
    InputStream in = null;
    OutputStream out = null;
    try {
      in = new FileInputStream(src);
      out = new FileOutputStream(dst);
      byte[] buf = new byte[BUFFER_SIZE];
      int len;
      while ((len = in.read(buf)) > 0) {
        out.write(buf, 0, len);
      }
    }
    finally {
      if (in != null) {
        in.close();
      }
      if (out != null) {
        out.close();
      }
    }
  }
}
