/*
 * $Id: MockLogisticClient.java 57355 2006-10-09 16:55:36Z letnog $
 */
package csbase.test.unit.mock;

import java.util.Locale;
import java.util.Map;

import csbase.client.Client;
import csbase.client.login.InitialContext;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.exception.CSBaseException;
import csbase.logic.ManifestVersion;
import csbase.test.unit.TestConfig;

/**
 * Esta classe representa um cliente sem interface grfica do csbase. 
 * responsvel por fazer o login. A partir de ento podemos fazer testes de
 * servios que esto executando em outra maquina virtual.
 */
public class MockCSBaseClient extends Client {

  /**
   * Construtor.
   * 
   * @param systemName Nome do sistema
   * @param parameterMap Mapa com o conjunto de parmentros do sistema. O par
   *        indispensvel nesse mapa : Client.SERVER_URL_PARAMETER (server_url)
   *        e seu valor (o padro  localhost:1099)
   */
  public MockCSBaseClient(String systemName, Map<String, String> parameterMap) {
    super(systemName, parameterMap);
  }

  /**
   * Faz o login do usurio
   * 
   * @return O contexto com o locale do usurio.
   */
  protected InitialContext executeDefaultLogin() {
    String login = TestConfig.getProperty(TestConfig.LOGIN_PROP,
      TestConfig.LOGIN_DEFAULT);
    String password = TestConfig.getProperty(TestConfig.PASSWORD_PROP,
      TestConfig.PASSWORD_DEFAULT);
    String language = TestConfig.getProperty(TestConfig.LOCALE_LANGUAGE_PROP,
      TestConfig.LOCALE_LANGUAGE_DEFAULT);
    String country = TestConfig.getProperty(TestConfig.LOCALE_COUNTRY_PROP,
      TestConfig.LOCALE_COUNTRY_DEFAULT);
    Locale locale = new Locale(language, country);
    try {
      ClientRemoteMonitor.getInstance().start(login, password, locale);
    } catch (CSBaseException ex) {
      ex.printStackTrace();
      return null;
    }
    boolean alive = ClientRemoteMonitor.getInstance().isAlive();
    if (!alive) {
      System.out.println("No foi possvel fazer o login.");
      return null;
    }
    return new InitialContext(locale);
  }

  /**
   * {@inheritDoc} Para execuo dos testes, no precisamos da interface.
   */
  @Override
  protected boolean executeClientUI(final InitialContext initialContext) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getVersion() {
    return new ManifestVersion(getClass()).getVersionName();
  }
}
