/*
 * $Id: FileConfigConverter.java 170738 2015-12-16 17:39:22Z fpina $
 */
package csbase.tools;

import java.io.File;

import tecgraf.javautils.core.lng.LNG;

/**
 * Conversor de x.csbase(_description) para .x.csbase(_description)
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileConfigConverter {

  /**
   * MODO DE TESTES...
   */
  private static boolean TEST_MODE = false;

  /**
   * VERBOSE
   */
  private static boolean VERBOSE_MODE = true;

  /**
   * Imprime texto se em modo verbose
   * 
   * @param msg mensagem
   */
  static private void verbose(final String msg) {
    if (VERBOSE_MODE) {
      System.out.println(msg);
    }
  }

  /**
   * Entrada do programa
   * 
   * @param args diretrios a serem verificados.
   */
  static public void main(String[] args) {
    String dirPath = null;
    for (final String arg : args) {
      if (arg.equals("-t")) {
        TEST_MODE = true;
      }
      else if (arg.equals("-v")) {
        VERBOSE_MODE = true;
      }
      else {
        dirPath = arg;
      }
    }
    if (dirPath == null) {
      System.out.println(LNG.get("FileConfigConverter.error.dir.path.notfound"));
      return;
    }
    substitutePath(dirPath);
  }

  /**
   * Substi
   * 
   * @param dirPath path do diretrio
   */
  private static void substitutePath(final String dirPath) {
    System.out.println(LNG.get("FileConfigConverter.dirpath.analyzing", new String[]{dirPath}));
    final File file = new File(dirPath);
    if (!file.exists()) {
      System.out.println(LNG.get("FileConfigConverter.error.dir.inexistent", new String[]{file.getAbsolutePath()}));
      return;
    }
    if (!file.isDirectory()) {
      System.out.println(LNG.get("FileConfigConverter.error.dir.notadir", new String[]{file.getAbsolutePath()}));
      return;
    }
    substituteFile(file);
  }

  /**
   * Faz replacement
   * 
   * @param file arquivo/diretrio
   */
  private static void substituteFile(final File file) {
    if (!file.exists()) {
      return;
    }
    if (file.isDirectory()) {
      final File[] children = file.listFiles();
      for (File f : children) {
        substituteFile(f);
      }
    }
    else {
      final String fileName = file.getName();
      if (looksNewFormat(fileName)) {
        final String path = file.getAbsolutePath();
        final String msg = LNG.get("FileConfigConverter.substitute.unaltered", new String[]{path});
        verbose(msg);
      }
      else if (looksOldFormat(fileName)) {
        final String newFileName = "." + fileName;
        final File newFile = new File(file.getParent(), newFileName);
        if (newFile.exists()) {
          final String path = newFile.getAbsolutePath();
          final String msg = LNG.get("FileConfigConverter.substitute.overwrote", new String[]{path});
          verbose(msg);
        }
        if (!TEST_MODE) {
          file.renameTo(newFile);
          final String pth1 = file.getAbsolutePath();
          final String pth2 = newFile.getAbsolutePath();
          final String msg = LNG.get("FileConfigConverter.substitute.mv", new String[]{pth1, pth2});
          verbose(msg);
        }
        else {
          final String pth1 = file.getAbsolutePath();
          final String pth2 = newFile.getAbsolutePath();
          final String msg = LNG.get("FileConfigConverter.substitute.mv.simulation", new String[]{pth1, pth2});
          verbose(msg);
        }
      }
    }
  }

  /**
   * Verifica se nome est no formato antigo
   * 
   * @param fileName nome do arquivo
   * @return indicativo de formato antigo
   */
  private static boolean looksOldFormat(String fileName) {
    final boolean cs = fileName.endsWith(".csbase");
    final boolean csb = fileName.endsWith(".csbase_description");
    final boolean pt = fileName.startsWith(".");
    return (!pt && (cs || csb));
  }

  /**
   * Verifica se nome est no formato novo
   * 
   * @param fileName nome do arquivo
   * @return indicativo de formato novo
   */
  private static boolean looksNewFormat(final String fileName) {
    final boolean cs = fileName.endsWith(".csbase");
    final boolean csb = fileName.endsWith(".csbase_description");
    final boolean pt = fileName.startsWith(".");
    return (pt && (cs || csb));
  }
}
