/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.api.user.v1;

import csbase.rest.api.user.v1.NotFoundException;
import csbase.rest.api.user.v1.UsersApiService;
import csbase.rest.api.user.v1.factories.UsersApiServiceFactory;
import csbase.rest.model.user.v1.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/users")
@Produces(value={"application/json;"})
@Api(description="the users API")
public class UsersApi {
    private final UsersApiService delegate = UsersApiServiceFactory.getUsersApi();

    @GET
    @Produces(value={"application/json;"})
    @ApiOperation(value="Return the list of all registered users.", notes="This endpoint return a list of *CSGrid* Users. You can use filters to limit your result.", response=User.class, responseContainer="List", tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successful.", response=User.class, responseContainer="List")})
    public Response usersGet(@ApiParam(value="Filter the users that contains this value in the name or login") @QueryParam(value="filter") String filter, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersGet(filter, locale, securityContext);
    }

    @GET
    @Path(value="/{userId}")
    @Produces(value={"application/json;"})
    @ApiOperation(value="Find an user by his ID.", notes="Return the user that is identified by the userId.", response=User.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successul.", response=User.class), @ApiResponse(code=400, message="User was not found", response=User.class)})
    public Response usersUserIdGet(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdGet(userId, locale, securityContext);
    }

    @GET
    @Path(value="/{userId}/photo")
    @Produces(value={"image/gif"})
    @ApiOperation(value="Get the user photo image", notes="Return the binary content of the photo image for the specified user.", response=File.class, tags={"Users"})
    @ApiResponses(value={@ApiResponse(code=200, message="Request was successful and the binary content of the photo image was returned", response=File.class), @ApiResponse(code=400, message="Specified user ID is missing or malformed", response=File.class), @ApiResponse(code=404, message="Photo image for the specified user was not found", response=File.class), @ApiResponse(code=500, message="Processing error occurred accessing the photo image", response=File.class)})
    public Response usersUserIdPhotoGet(@ApiParam(value="The ID of an user.", required=true) @PathParam(value="userId") String userId, @ApiParam(value="The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        return this.delegate.usersUserIdPhotoGet(userId, locale, securityContext);
    }
}

