/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.api.user.v1.impl;

import csbase.exception.ParseException;
import csbase.logic.restservice.RestUtil;
import csbase.remote.RestServiceInterface;
import csbase.rest.api.user.v1.NotFoundException;
import csbase.rest.api.user.v1.UsersApiService;
import csbase.rest.api.user.v1.impl.UsersApiServiceImpl;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

@Path(value="/links")
@Produces(value={"application/json;"})
public class LinksApi {
    public static final String RESOURCE_BUNDLE = "language.LinksApi";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/avatar/{token}")
    @Produces(value={"image/gif"})
    public Response linksTokenAvatarGet(@PathParam(value="token") String token, @QueryParam(value="locale") String locale, @Context SecurityContext securityContext) throws NotFoundException {
        RestUtil.setLocale((String)locale);
        try {
            RestServiceInterface restService = (RestServiceInterface)RestUtil.getCSBaseService(RestServiceInterface.class);
            HashMap attributes = new HashMap();
            String currentUser = restService.parserToken(token, attributes);
            restService.setUserId(currentUser);
            String userId = attributes.get("userId").toString();
            UsersApiServiceImpl service = new UsersApiServiceImpl();
            Response response = ((UsersApiService)service).usersUserIdPhotoGet(userId, locale, securityContext);
            return response;
        }
        catch (ParseException e) {
            Response response = RestUtil.buildException((String)RestUtil.getString((String)RESOURCE_BUNDLE, (String)"links.token.invalid"), (Response.Status)Response.Status.FORBIDDEN);
            return response;
        }
        finally {
            RestUtil.setLocale(null);
        }
    }
}

