/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.api.user.v1.impl;

import csbase.logic.restservice.RestUtil;
import csbase.remote.AdministrationServiceInterface;
import csbase.remote.RestServiceInterface;
import csbase.rest.api.user.v1.NotFoundException;
import csbase.rest.api.user.v1.UsersApiService;
import csbase.rest.model.user.v1.User;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;

public class UsersApiServiceImpl
extends UsersApiService {
    public static final String RESOURCE_BUNDLE = "language.UsersApi";
    public static final String ATTRIBUTE_USER_ID = "userId";

    public String createAvatarLink(Object userId) {
        RestServiceInterface restService = (RestServiceInterface)RestUtil.getCSBaseService(RestServiceInterface.class);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(ATTRIBUTE_USER_ID, userId);
        Calendar c = Calendar.getInstance();
        c.add(1, 10);
        StringBuilder builder = new StringBuilder();
        builder.append(restService.getExternalURL());
        builder.append("/links/avatar/");
        builder.append(restService.createToken(RestUtil.getCurrentUser(), attributes, c.getTime()));
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response usersGet(String filter, String locale, SecurityContext securityContext) {
        RestUtil.setLocale((String)locale);
        try {
            RestUtil.logInfoMessage((String)RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.get.all.users.info"));
            AdministrationServiceInterface adminService = (AdministrationServiceInterface)RestUtil.getCSBaseService(AdministrationServiceInterface.class);
            List allUsers = adminService.getAllUsers();
            ArrayList<User> users = new ArrayList<User>();
            for (csbase.logic.User user : allUsers) {
                if (filter != null && (filter == null || filter.trim().equals("") || (user.getName() == null || user.getName().toLowerCase().indexOf(filter) < 0) && (user.getLogin() == null || user.getLogin().toLowerCase().indexOf(filter) < 0))) continue;
                User restUser = new User();
                restUser.setId(user.getId().toString());
                restUser.setLogin(user.getLogin());
                restUser.setName(user.getName());
                restUser.setAvatar(this.createAvatarLink(user.getId()));
                users.add(restUser);
            }
            Response response = Response.ok().entity(users).build();
            return response;
        }
        catch (RemoteException r) {
            Response response = RestUtil.buildException((Exception)r, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            RestUtil.setLocale(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response usersUserIdPhotoGet(String userId, String locale, SecurityContext securityContext) throws NotFoundException {
        Response response;
        RestUtil.setLocale((String)locale);
        try {
            RestUtil.logInfoMessage((String)MessageFormat.format(RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.get.photo.info"), userId));
            AdministrationServiceInterface adminService = (AdministrationServiceInterface)RestUtil.getCSBaseService(AdministrationServiceInterface.class);
            if (userId == null || csbase.logic.User.getUser((Object)userId) == null) {
                Response response2 = RestUtil.buildException((String)RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.id.invalid"), (Response.Status)Response.Status.BAD_REQUEST);
                return response2;
            }
            File file = adminService.getPhotoFile((Object)userId);
            if (file == null) {
                Response response3 = RestUtil.buildException((String)RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.photo.not.found"), (Response.Status)Response.Status.NOT_FOUND);
                return response3;
            }
            final FileInputStream is = new FileInputStream(file);
            StreamingOutput output = new StreamingOutput(){

                public void write(OutputStream out) throws IOException {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = is.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    is.close();
                }
            };
            Response response4 = Response.ok((Object)output).build();
            return response4;
        }
        catch (RemoteException e) {
            response = RestUtil.buildException((Exception)e, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        catch (IOException e) {
            response = RestUtil.buildException((Exception)e, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            RestUtil.setLocale(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response usersUserIdGet(String userId, String locale, SecurityContext securityContext) throws NotFoundException {
        RestUtil.setLocale((String)locale);
        try {
            RestUtil.logInfoMessage((String)MessageFormat.format(RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.get.id.info"), userId));
            if (userId == null || csbase.logic.User.getUser((Object)userId) == null) {
                Response response = RestUtil.buildException((String)RestUtil.getString((String)RESOURCE_BUNDLE, (String)"users.id.invalid"), (Response.Status)Response.Status.BAD_REQUEST);
                return response;
            }
            csbase.logic.User user = csbase.logic.User.getUser((Object)userId);
            User restUser = new User();
            restUser.setId(user.getId().toString());
            restUser.setLogin(user.getLogin());
            restUser.setName(user.getName());
            restUser.setAvatar(this.createAvatarLink(user.getId()));
            Response response = Response.ok((Object)restUser).build();
            return response;
        }
        catch (RemoteException e) {
            Response response = RestUtil.buildException((Exception)e, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            return response;
        }
        finally {
            RestUtil.setLocale(null);
        }
    }
}

