package csbase.adapter.user;

import ibase.user.User;

/**
 * Gateway para um usuário no CSBase.
 *
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseUser implements User {

  /**
   * Usuário no CSBase.
   */
  private csbase.logic.User user;

  /**
   * @param user
   */
  public CSBaseUser(csbase.logic.User user) {
    this.user = user;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getId() {
    return user.getId().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return user.getName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    return user.getLogin();
  }

}
