package csbase.adapter.user;

import csbase.remote.AdministrationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import ibase.exception.InternalServiceException;
import ibase.user.User;
import ibase.user.UserService;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/**
 * Implementação do adaptador CSBase para o serviço de usuários.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CSBaseUserServiceImpl implements UserService {

  /**
   * {@inheritDoc}
   */
  @Override
  public void setLocale(Locale locale) {
    ClientRemoteLocator.administrationService.setLocale(locale);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<User> getAllUsers() {
    AdministrationServiceInterface service =
      ClientRemoteLocator.administrationService;
    List<csbase.logic.User> users;
    try {
      users = service.getAllUsers();
      List<User> usersToReturn = new ArrayList<User>();
      users.forEach(u -> usersToReturn.add(new CSBaseUser(u)));
      return usersToReturn;
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public File getUserPhotoFile(String userId) {
    try {
      AdministrationServiceInterface service =
        ClientRemoteLocator.administrationService;
      return service.getPhotoFile(userId);
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public User getUser(String userId) {
    try {
      AdministrationServiceInterface service =
        ClientRemoteLocator.administrationService;
      csbase.logic.User user = service.getUser(userId);
      if (user == null) {
        return null;
      }
      return new CSBaseUser(service.getUser(userId));
    }
    catch (Throwable e) {
      throw new InternalServiceException(e);
    }
  }

}
