package csbase.util.messages.dao;

import java.io.Serializable;
import java.util.Collection;

import csbase.util.messages.MessageStore;

/**
 * Interface de um objeto de persistncia de {@link MessageStore}.
 * 
 * @author Tecgraf
 */
public interface IMessageStoreDAO {

  /**
   * Salva os componentes responsveis pelo armazenamento das mensagens em
   * tpicos.
   * 
   * @param stores os componentes responsveis pelo armazenamento das mensagens
   *        em tpicos.
   * @param <T> tipo dos componentes
   *
   */
  <T extends Collection<MessageStore> & Serializable> void saveAllMessageStores(
    T stores);

  /**
   * Obtm os componentes responsveis pelo armazenamento das mensagens em
   * tpicos.
   * 
   * @return os componentes responsveis pelo armazenamento das mensagens em
   *         tpicos.
   */
  Collection<MessageStore> getAllMessageStores();
}
