/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.io.File;
import java.io.FileFilter;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSystemUtils {
    public static final String VERSION_CONTROL_DIR = ".svn";
    private static final boolean READ_ALLOWED = FileSystemUtils._canRead();

    public static final boolean canRead() {
        return READ_ALLOWED;
    }

    private static boolean _canRead() {
        try {
            new File(".").canRead();
            return true;
        }
        catch (AccessControlException ex) {
            return false;
        }
    }

    public static boolean fileExists(String path) {
        return FileSystemUtils.fileExists(new File(path));
    }

    public static boolean fileExists(File file) {
        return file.exists() && file.isFile();
    }

    public static boolean dirExists(String path) {
        return FileSystemUtils.dirExists(new File(path));
    }

    public static boolean dirExists(File dir) {
        return dir.exists() && dir.isDirectory();
    }

    public static File[] getSubDirs(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " n\u00e3o existe");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getAbsolutePath() + " n\u00e3o \u00e9 um diret\u00f3rio");
        }
        File[] subDirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        });
        return subDirs;
    }

    public static boolean deleteRecursively(File file, Logger logger) {
        boolean removed;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children;
            for (File child : children = file.listFiles()) {
                boolean success = FileSystemUtils.deleteRecursively(child, logger);
                if (success) continue;
                return false;
            }
        }
        if (!(removed = file.delete())) {
            String path = file.getAbsolutePath();
            String err = String.format("Falha na remo\u00e7\u00e3o do %s %s", file.isDirectory() ? "diret\u00f3rio" : "arquivo", path);
            if (logger != null) {
                logger.log(Level.SEVERE, err);
            }
        }
        return removed;
    }

    public static boolean deleteRecursively(File file) {
        return FileSystemUtils.deleteRecursively(file, null);
    }
}

